/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.RestHandler;

@Path(value="login")
public class CookieLogin
extends RestHandler {
    @GET
    @Produces(value={"text/plain"})
    public Response login(@QueryParam(value="user") String user, @QueryParam(value="pass") String pass, @Context UriInfo uri) {
        AgentPath agentPath;
        try {
            if (!Gateway.getAuthenticator().authenticate(user, pass, null)) {
                throw ItemUtils.createWebAppException("Bad username/password", Response.Status.UNAUTHORIZED);
            }
        }
        catch (InvalidDataException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Problem logging in");
        }
        catch (ObjectNotFoundException e1) {
            Logger.msg((int)5, (String)"CookieLogin.login() - Bad username/password");
            throw ItemUtils.createWebAppException("Bad username/password", Response.Status.UNAUTHORIZED);
        }
        try {
            agentPath = Gateway.getLookup().getAgentPath(user);
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Agent '" + user + "' not found", Response.Status.NOT_FOUND);
        }
        RestHandler.AuthData agentData = (RestHandler)this.new RestHandler.AuthData(agentPath);
        try {
            int cookieLife = Gateway.getProperties().getInt("REST.loginCookieLife", 0);
            NewCookie cookie = cookieLife > 0 ? new NewCookie("cauth", this.encryptAuthData(agentData), "/", null, null, cookieLife, false) : new NewCookie("cauth", this.encryptAuthData(agentData));
            return Response.ok().cookie(new NewCookie[]{cookie}).build();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Error creating cookie");
        }
    }
}

