/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.restapi.ItemUtils;

@Path(value="/item/{uuid}/collection")
public class ItemCollection
extends ItemUtils {
    @GET
    @Produces(value={"application/json"})
    public Response getCollections(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemCollection.getProxy(uuid);
        return this.toJSON(this.enumerate(item, "Collection", "collection", uri));
    }

    @GET
    @Path(value="{name}")
    @Produces(value={"application/json"})
    public Response getLastCollection(@PathParam(value="uuid") String uuid, @PathParam(value="name") String collName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemCollection.getProxy(uuid);
        try {
            return this.toJSON(this.makeCollectionData(item.getCollection(collName), uri));
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="{name}/version")
    public Response getCollectionVersions(@PathParam(value="uuid") String uuid, @PathParam(value="name") String collName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemCollection.getProxy(uuid);
        return this.toJSON(this.enumerate(item, "Collection/" + collName, "collection/" + collName + "/version", uri));
    }

    @GET
    @Path(value="{name}/version/{version}")
    public Response getCollectionVersion(@PathParam(value="uuid") String uuid, @PathParam(value="name") String collName, @PathParam(value="version") String collVersion, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemCollection.getProxy(uuid);
        try {
            return this.toJSON(this.makeCollectionData(item.getCollection(collName, collVersion.equals("last") ? null : Integer.valueOf(collVersion)), uri));
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (NumberFormatException e) {
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.NOT_FOUND);
        }
    }
}

