/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.util.LinkedHashMap;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.restapi.ItemRoot;
import org.cristalise.restapi.ItemUtils;

@Path(value="/item/{uuid}/data")
public class ItemData
extends ItemUtils {
    @GET
    @Produces(value={"application/json"})
    public Response getSchemas(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        return this.toJSON(this.enumerate(item, "ViewPoint", "data", uri));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}")
    public Response getViewNames(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        return this.toJSON(this.enumerate(item, "ViewPoint/" + schema, "data/" + schema, uri));
    }

    private Response queryData(String uuid, String schema, String viewName, Cookie authCookie, UriInfo uri, boolean json) {
        Outcome oc;
        Viewpoint view;
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        try {
            view = item.getViewpoint(schema, viewName);
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.NOT_FOUND);
        }
        try {
            oc = view.getOutcome();
        }
        catch (ObjectNotFoundException | PersistencyException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Database error loading outcome for view " + viewName + " of schema " + schema);
        }
        try {
            return this.getOutcomeResponse(oc, view.getEvent(), json);
        }
        catch (InvalidDataException | ObjectNotFoundException | PersistencyException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Database error loading event data for view " + viewName + " of schema " + schema);
        }
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="{schema}/{viewName}")
    public Response queryXMLData(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="viewName") String viewName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        return this.queryData(uuid, schema, viewName, authCookie, uri, false);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}/{viewName}")
    public Response queryJSONData(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="viewName") String viewName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        return this.queryData(uuid, schema, viewName, authCookie, uri, true);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}/{viewName}/event")
    public Response getViewEvent(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="viewName") String viewName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        Event ev;
        Viewpoint view;
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        try {
            view = item.getViewpoint(schema, viewName);
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Database error loading view " + viewName + " of schema " + schema);
        }
        try {
            ev = view.getEvent();
        }
        catch (InvalidDataException | ObjectNotFoundException | PersistencyException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Database error loading event data for view " + viewName + " of schema " + schema);
        }
        return this.toJSON(this.makeEventData(ev, uri));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}/{viewName}/history")
    public Response getAllEventsForView(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="viewName") String viewName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        History history;
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        try {
            history = (History)item.getObject("AuditTrail");
            history.activate();
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException("Could not load History");
        }
        LinkedHashMap eventList = new LinkedHashMap();
        for (int i = 0; i <= history.getLastId(); ++i) {
            Event ev = (Event)history.get((Object)i);
            if (!schema.equals(ev.getSchemaName()) || !viewName.equals(ev.getViewName())) continue;
            String evId = String.valueOf(i);
            LinkedHashMap<String, Object> eventDetails = new LinkedHashMap<String, Object>();
            eventDetails.put("timestamp", ev.getTimeString());
            eventDetails.put("data", uri.getAbsolutePathBuilder().path(evId).build(new Object[0]));
            eventList.put(evId, eventDetails);
        }
        return this.toJSON(eventList);
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="{schema}/{viewName}/history/{event}")
    public Response getOutcomeForEvent(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="viewName") String viewName, @PathParam(value="event") Integer eventId, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        Outcome oc;
        Event ev;
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        try {
            ev = (Event)item.getObject("AuditTrail/" + eventId);
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException("Event " + eventId + " was not found", Response.Status.NOT_FOUND);
        }
        if (!schema.equals(ev.getSchemaName()) || !viewName.equals(ev.getViewName())) {
            throw ItemUtils.createWebAppException("Event does not belong to this data", Response.Status.BAD_REQUEST);
        }
        try {
            oc = (Outcome)item.getObject("Outcome/" + schema + "/" + ev.getSchemaVersion() + "/" + eventId);
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException("Outcome " + eventId + " was not found", Response.Status.NOT_FOUND);
        }
        return this.getOutcomeResponse(oc, ev, false);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}/{viewName}/history/{event}/event")
    public Response getOutcomeEvent(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="viewName") String viewName, @PathParam(value="event") Integer eventId, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        Event ev;
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        try {
            ev = (Event)item.getObject("AuditTrail/" + eventId);
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException("Event " + eventId + " was not found", Response.Status.NOT_FOUND);
        }
        if (!schema.equals(ev.getSchemaName()) || !viewName.equals(ev.getViewName())) {
            throw ItemUtils.createWebAppException("Event does not belong to this data", Response.Status.BAD_REQUEST);
        }
        return this.toJSON(this.makeEventData(ev, uri));
    }
}

