/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.scripting.ScriptErrorException;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.restapi.ItemUtils;

@Path(value="/item/{uuid}")
public class ItemRoot
extends ItemUtils {
    @GET
    @Path(value="name")
    @Produces(value={"text/plain"})
    public String getName(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie) {
        this.checkAuthCookie(authCookie);
        return ItemRoot.getProxy(uuid).getName();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getItemSummary(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        LinkedHashMap<String, Object> itemSummary = new LinkedHashMap<String, Object>();
        itemSummary.put("name", item.getName());
        try {
            itemSummary.put("properties", ItemRoot.getPropertySummary(item));
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("No Properties found", Response.Status.BAD_REQUEST);
        }
        itemSummary.put("data", this.enumerate(item, "ViewPoint", "data", uri));
        itemSummary.put("collections", this.enumerate(item, "Collection", "collection", uri));
        return this.toJSON(itemSummary);
    }

    @OPTIONS
    @Produces(value={"application/json"})
    public Response getJobs(@PathParam(value="uuid") String uuid, @QueryParam(value="agent") String agentName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        ArrayList jobList;
        ItemProxy item = ItemRoot.getProxy(uuid);
        AgentProxy agent = this.getAgent(agentName, authCookie);
        try {
            jobList = item.getJobList(agent);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Error loading joblist");
        }
        ArrayList<LinkedHashMap<String, Object>> jobListData = new ArrayList<LinkedHashMap<String, Object>>();
        String itemName = item.getName();
        for (Job job : jobList) {
            jobListData.add(this.makeJobData(job, itemName, uri));
        }
        return this.toJSON(jobListData);
    }

    @POST
    @Consumes(value={"text/xml"})
    @Produces(value={"text/xml"})
    @Path(value="{activityPath: .*}")
    public String requestTransition(String postData, @PathParam(value="uuid") String uuid, @PathParam(value="activityPath") String actPath, @QueryParam(value="transition") String transition, @QueryParam(value="agent") String agentName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        ArrayList jobList;
        if (transition == null) {
            for (String key : uri.getQueryParameters().keySet()) {
                List vals = (List)uri.getQueryParameters().get((Object)key);
                if (vals.size() != 1 || ((String)vals.get(0)).length() != 0) continue;
                transition = key;
                break;
            }
            if (transition == null) {
                transition = "Done";
            }
        }
        ItemProxy item = ItemRoot.getProxy(uuid);
        AgentProxy agent = this.getAgent(agentName, authCookie);
        try {
            jobList = item.getJobList(agent);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Error loading joblist");
        }
        Job thisJob = null;
        for (Job job : jobList) {
            if (!job.getStepPath().equals(actPath) || !job.getTransition().getName().equalsIgnoreCase(transition)) continue;
            thisJob = job;
        }
        if (thisJob == null) {
            throw ItemUtils.createWebAppException("Job not found for agent", Response.Status.NOT_FOUND);
        }
        try {
            if (thisJob.hasOutcome()) {
                thisJob.setOutcome(postData);
            }
            return agent.execute(thisJob);
        }
        catch (InvalidCollectionModification | InvalidDataException | ObjectAlreadyExistsException | ScriptErrorException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (AccessRightsException e) {
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.UNAUTHORIZED);
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (InvalidTransitionException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.CONFLICT);
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

