/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.collection.AggregationMember;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionDescription;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.KeyValuePair;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.restapi.RestHandler;
import org.json.XML;

public abstract class ItemUtils
extends RestHandler {
    final DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    protected static LinkedHashMap<String, String> getPropertySummary(ItemProxy item) throws ObjectNotFoundException {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        for (String propName : item.getContents("Property")) {
            if (propName.equalsIgnoreCase("name")) continue;
            props.put(propName, item.getProperty(propName));
        }
        return props;
    }

    protected static ItemProxy getProxy(String uuid) {
        ItemProxy item;
        ItemPath itemPath;
        try {
            itemPath = Gateway.getLookup().getItemPath(uuid);
        }
        catch (InvalidItemPathException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.NOT_FOUND);
        }
        try {
            item = Gateway.getProxyManager().getProxy((Path)itemPath);
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.NOT_FOUND);
        }
        return item;
    }

    public LinkedHashMap<String, URI> enumerate(ItemProxy item, String dataPath, String uriPath, UriInfo uri) {
        String[] children;
        try {
            children = Gateway.getStorage().getClusterContents(item.getPath(), dataPath);
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Database Error");
        }
        LinkedHashMap<String, URI> childrenWithLinks = new LinkedHashMap<String, URI>();
        for (String child : children) {
            childrenWithLinks.put(child, uri.getBaseUriBuilder().path("item").path(item.getPath().getUUID().toString()).path(uriPath).path(child).build(new Object[0]));
        }
        return childrenWithLinks;
    }

    protected Response getOutcomeResponse(Outcome oc, Event ev, boolean json) {
        Date eventDate;
        try {
            eventDate = this.dateFormatter.parse(ev.getTimeString());
        }
        catch (ParseException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Invalid timestamp in event " + ev.getID() + ": " + ev.getTimeString());
        }
        String result = json ? XML.toJSONObject((String)oc.getData()).toString() : oc.getData();
        return Response.ok((Object)result).lastModified(eventDate).build();
    }

    protected LinkedHashMap<String, Object> makeEventData(Event ev, UriInfo uri) {
        LinkedHashMap<String, Object> eventData = new LinkedHashMap<String, Object>();
        eventData.put("id", ev.getID());
        eventData.put("timestamp", ev.getTimeString());
        eventData.put("agent", ev.getAgentPath().getAgentName());
        eventData.put("role", ev.getAgentRole());
        if (ev.getSchemaName() != null && ev.getSchemaName().length() > 0) {
            LinkedHashMap<String, Object> outcomeData = new LinkedHashMap<String, Object>();
            outcomeData.put("name", ev.getViewName());
            outcomeData.put("schema", ev.getSchemaName() + " v" + ev.getSchemaVersion());
            outcomeData.put("schemaData", uri.getBaseUriBuilder().path("schema").path(ev.getSchemaName()).path(String.valueOf(ev.getSchemaVersion())).build(new Object[0]));
            outcomeData.put("data", uri.getBaseUriBuilder().path("item").path(ev.getItemUUID()).path("history").path(String.valueOf(ev.getID())).path("data").build(new Object[0]));
            eventData.put("outcome", outcomeData);
        }
        LinkedHashMap<String, String> activityData = new LinkedHashMap<String, String>();
        activityData.put("name", ev.getStepName());
        activityData.put("path", ev.getStepPath());
        activityData.put("type", ev.getStepType());
        eventData.put("activity", activityData);
        LinkedHashMap<String, Object> transData = new LinkedHashMap<String, Object>();
        try {
            StateMachine sm = LocalObjectLoader.getStateMachine((String)ev.getStateMachineName(), (int)ev.getStateMachineVersion());
            transData.put("name", sm.getTransition(ev.getTransition()).getName());
            transData.put("origin", sm.getState(ev.getOriginState()).getName());
            transData.put("target", sm.getState(ev.getTargetState()).getName());
            transData.put("stateMachine", ev.getStateMachineName() + " v" + ev.getStateMachineVersion());
            transData.put("stateMachineData", uri.getBaseUriBuilder().path("stateMachine").path(ev.getStateMachineName()).path(String.valueOf(ev.getStateMachineVersion())).build(new Object[0]));
            eventData.put("transition", transData);
        }
        catch (ObjectNotFoundException e) {
            eventData.put("transition", "ERROR: State Machine " + ev.getStateMachineName() + " v" + ev.getStateMachineVersion() + " not found!");
        }
        catch (InvalidDataException e) {
            eventData.put("transition", "ERROR: State Machine definition " + ev.getStateMachineName() + " v" + ev.getStateMachineVersion() + " not valid!");
        }
        return eventData;
    }

    protected LinkedHashMap<String, Object> makeJobData(Job job, String itemName, UriInfo uri) {
        LinkedHashMap<String, Object> jobData = new LinkedHashMap<String, Object>();
        String agentName = job.getAgentName();
        if (agentName != null && agentName.length() > 0) {
            jobData.put("agent", agentName);
        }
        jobData.put("role", job.getAgentRole());
        LinkedHashMap<String, Object> itemData = new LinkedHashMap<String, Object>();
        itemData.put("name", itemName);
        itemData.put("location", uri.getBaseUriBuilder().path("item").path(job.getItemUUID()).build(new Object[0]));
        jobData.put("item", itemData);
        LinkedHashMap<String, Object> activityData = new LinkedHashMap<String, Object>();
        activityData.put("name", job.getStepName());
        activityData.put("path", job.getStepPath());
        activityData.put("type", job.getStepType());
        LinkedHashMap<String, String> activityPropData = new LinkedHashMap<String, String>();
        for (KeyValuePair actProp : job.getKeyValuePairs()) {
            String key = actProp.getKey();
            String value = job.getActPropString(key);
            if (value == null || value.length() <= 0) continue;
            activityPropData.put(key, job.getActPropString(key));
        }
        activityData.put("properties", activityPropData);
        jobData.put("activity", activityData);
        LinkedHashMap<String, Object> stateData = new LinkedHashMap<String, Object>();
        stateData.put("name", job.getTransition().getName());
        stateData.put("origin", job.getOriginStateName());
        stateData.put("target", job.getTargetStateName());
        stateData.put("stateMachine", job.getActPropString("StateMachineName") + " v" + job.getActPropString("StateMachineVersion"));
        stateData.put("stateMachineData", uri.getBaseUriBuilder().path("stateMachine").path(job.getActPropString("StateMachineName")).path(job.getActPropString("StateMachineVersion")).build(new Object[0]));
        jobData.put("transition", stateData);
        if (job.hasOutcome()) {
            LinkedHashMap<String, Object> outcomeData = new LinkedHashMap<String, Object>();
            try {
                outcomeData.put("required", job.isOutcomeRequired());
                outcomeData.put("schema", job.getSchema().getName() + " v" + job.getSchema().getVersion());
                outcomeData.put("schemaData", uri.getBaseUriBuilder().path("schema").path(job.getSchema().getName()).path(String.valueOf(job.getSchema().getVersion())).build(new Object[0]));
                jobData.put("data", outcomeData);
            }
            catch (InvalidDataException | ObjectNotFoundException e) {
                Logger.error((Throwable)e);
                jobData.put("data", "Schema not found");
            }
        }
        return jobData;
    }

    protected LinkedHashMap<String, Object> makeCollectionData(Collection<?> coll, UriInfo uri) {
        LinkedHashMap<String, Object> collData = new LinkedHashMap<String, Object>();
        collData.put("name", coll.getName());
        collData.put("version", coll.getVersionName());
        String collType = "Collection";
        if (coll instanceof Aggregation) {
            collType = "Aggregation";
        } else if (coll instanceof Dependency) {
            collType = "Dependency";
        }
        collData.put("type", collType);
        collData.put("isDescription", coll instanceof CollectionDescription);
        if (coll instanceof Dependency) {
            Dependency dep = (Dependency)coll;
            this.addProps(collData, dep.getProperties(), dep.getClassProps(), true);
        }
        LinkedHashMap<String, LinkedHashMap<String, Object>> memberData = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        for (CollectionMember member : coll.getMembers().list) {
            LinkedHashMap<String, Object> thisMemberData = new LinkedHashMap<String, Object>();
            if (member.getItemPath() != null) {
                thisMemberData.put("item", uri.getBaseUriBuilder().path("item").path(member.getItemPath().getUUID().toString()).build(new Object[0]));
            } else {
                thisMemberData.put("item", "");
            }
            this.addProps(thisMemberData, member.getProperties(), member.getClassProps(), coll instanceof Aggregation);
            if (member instanceof AggregationMember) {
                AggregationMember aggMem = (AggregationMember)member;
                LinkedHashMap<String, Integer> geo = new LinkedHashMap<String, Integer>();
                geo.put("x", aggMem.getCentrePoint().x);
                geo.put("y", aggMem.getCentrePoint().y);
                geo.put("w", aggMem.getWidth());
                geo.put("h", aggMem.getHeight());
                thisMemberData.put("geometry", geo);
            }
            memberData.put(String.valueOf(member.getID()), thisMemberData);
        }
        collData.put("members", memberData);
        return collData;
    }

    private void addProps(LinkedHashMap<String, Object> collData, CastorHashMap props, String classProps, boolean includeClassProps) {
        List<String> propList = null;
        if (classProps != null) {
            propList = Arrays.asList(classProps.split(","));
        }
        LinkedHashMap<String, Object> classPropData = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> propData = new LinkedHashMap<String, Object>();
        for (KeyValuePair prop : props.getKeyValuePairs()) {
            if (propList != null && propList.contains(prop.getKey())) {
                classPropData.put(prop.getKey(), prop.getValue());
                continue;
            }
            propData.put(prop.getKey(), prop.getValue());
        }
        if (classPropData.size() > 0 && includeClassProps) {
            collData.put("classIdentifiers", classPropData);
        }
        if (propData.size() > 0) {
            collData.put("properties", propData);
        }
    }

    public static WebApplicationException createWebAppException(String msg) {
        return ItemUtils.createWebAppException(msg, Response.Status.INTERNAL_SERVER_ERROR);
    }

    public static WebApplicationException createWebAppException(String msg, Response.Status status) {
        return ItemUtils.createWebAppException(msg, null, status);
    }

    public static WebApplicationException createWebAppException(String msg, Exception ex, Response.Status status) {
        Logger.debug((int)8, (String)("ItemUtils.createWebAppException() - msg:" + msg + "status:" + status));
        if (Gateway.getProperties().getBoolean("REST.Debug.errorsWithBody", false)) {
            StringBuffer sb = new StringBuffer(msg);
            if (ex != null) {
                sb.append(" - Exception:" + ex.getMessage());
            }
            return new WebApplicationException(sb.toString(), Response.status((Response.Status)status).entity((Object)msg).build());
        }
        return new WebApplicationException(msg, status);
    }
}

