/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.net.URI;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.RestHandler;

@javax.ws.rs.Path(value="/domain")
public class PathAccess
extends RestHandler {
    @GET
    @Produces(value={"application/json"})
    public Response queryPath(@DefaultValue(value="0") @QueryParam(value="start") Integer start, @QueryParam(value="batch") Integer batchSize, @QueryParam(value="search") String search, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        return this.queryPath("/", start, batchSize, search, authCookie, uri);
    }

    @GET
    @javax.ws.rs.Path(value="{path: .*}")
    @Produces(value={"application/json"})
    public Response queryPath(@PathParam(value="path") String path, @DefaultValue(value="0") @QueryParam(value="start") Integer start, @QueryParam(value="batch") Integer batchSize, @QueryParam(value="search") String search, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        DomainPath domPath = new DomainPath(path);
        if (batchSize == null) {
            batchSize = Gateway.getProperties().getInt("REST.Path.DefaultBatchSize", Gateway.getProperties().getInt("REST.DefaultBatchSize", 75));
        }
        if (!domPath.exists()) {
            throw ItemUtils.createWebAppException("Domain path doesn't exis", Response.Status.NOT_FOUND);
        }
        try {
            ItemPath item = domPath.getItemPath();
            return Response.seeOther((URI)uri.getBaseUriBuilder().path("item").path(item.getUUID().toString()).build(new Object[0])).build();
        }
        catch (ObjectNotFoundException ex) {
            int i;
            Iterator childSearch;
            LinkedHashMap<String, URI> childPathData = new LinkedHashMap<String, URI>();
            if (search == null) {
                childSearch = Gateway.getLookup().getChildren((Path)domPath);
            } else {
                String[] terms = search.split(",");
                Property[] props = new Property[terms.length];
                for (int i2 = 0; i2 < terms.length; ++i2) {
                    if (terms[i2].contains(":")) {
                        String[] nameval = terms[i2].split(":");
                        if (nameval.length != 2) {
                            throw ItemUtils.createWebAppException("Invalid search term: " + terms[i2], Response.Status.BAD_REQUEST);
                        }
                        props[i2] = new Property(nameval[0], nameval[1]);
                        continue;
                    }
                    if (i2 == 0) {
                        props[i2] = new Property(BuiltInItemProperties.NAME, terms[i2]);
                        continue;
                    }
                    throw ItemUtils.createWebAppException("Only the first search term may omit property name", Response.Status.BAD_REQUEST);
                }
                childSearch = Gateway.getLookup().search((Path)domPath, props);
            }
            for (i = 0; i < start && childSearch.hasNext(); ++i) {
                childSearch.next();
            }
            for (i = 0; i < batchSize && childSearch.hasNext(); ++i) {
                String itemName;
                URI nextPathURI;
                Path nextPath = (Path)childSearch.next();
                Logger.msg((String)nextPath.toString());
                if (nextPath instanceof DomainPath) {
                    DomainPath nextDom = (DomainPath)nextPath;
                    try {
                        ItemPath nextItem = nextDom.getItemPath();
                        nextPathURI = uri.getBaseUriBuilder().path("item").path(nextItem.getUUID().toString()).build(new Object[0]);
                    }
                    catch (ObjectNotFoundException ex2) {
                        nextPathURI = uri.getAbsolutePathBuilder().path(nextDom.getName()).build(new Object[0]);
                    }
                    childPathData.put(nextDom.getName(), nextPathURI);
                    continue;
                }
                if (!(nextPath instanceof ItemPath)) continue;
                ItemPath itemPath = (ItemPath)nextPath;
                nextPathURI = uri.getBaseUriBuilder().path("item").path(itemPath.getUUID().toString()).build(new Object[0]);
                try {
                    itemName = Gateway.getProxyManager().getProxy((Path)itemPath).getName();
                }
                catch (ObjectNotFoundException e) {
                    itemName = itemPath.getUUID().toString();
                }
                childPathData.put(itemName, nextPathURI);
            }
            if (childSearch.hasNext()) {
                childPathData.put("nextBatch", uri.getAbsolutePathBuilder().replaceQueryParam("start", new Object[]{start + batchSize}).replaceQueryParam("batch", new Object[]{batchSize}).build(new Object[0]));
            }
            return this.toJSON(childPathData);
        }
    }
}

