/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Date;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import org.codehaus.jackson.map.ObjectMapper;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.InvalidAgentPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.restapi.ItemUtils;

public class RestHandler {
    private ObjectMapper mapper = new ObjectMapper();
    private boolean requireLogin = Gateway.getProperties().getBoolean("REST.requireLoginCookie", true);
    private static SecretKey cookieKey;
    private static Cipher encryptCipher;
    private static Cipher decryptCipher;
    public static final String COOKIENAME = "cauth";

    public RestHandler() {
        if (cookieKey == null) {
            try {
                try {
                    RestHandler.initKeys(256);
                }
                catch (InvalidKeyException ex) {
                    if (!Gateway.getProperties().getBoolean("REST.allowWeakKey", false)) {
                        Logger.error((Throwable)ex);
                        Logger.die((String)"Weak cookie crypto not allowed, and unlimited strength crypto not installed.");
                    }
                    Logger.msg((String)"Unlimited crypto not installed. Trying 128-bit key.");
                    RestHandler.initKeys(128);
                }
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
                throw ItemUtils.createWebAppException("Error initializing cookie encryption", e, Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
    }

    private static void initKeys(int keySize) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(keySize);
        cookieKey = kgen.generateKey();
        System.out.println("Cookie key: " + DatatypeConverter.printBase64Binary((byte[])cookieKey.getEncoded()));
        encryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        encryptCipher.init(1, cookieKey);
        decryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        decryptCipher.init(2, (Key)cookieKey, new IvParameterSpec(encryptCipher.getIV()));
    }

    private AuthData decryptAuthData(String authData) throws InvalidAgentPathException, IllegalBlockSizeException, BadPaddingException, InvalidDataException {
        byte[] bytes = DatatypeConverter.parseBase64Binary((String)authData);
        return new AuthData(decryptCipher.doFinal(bytes));
    }

    protected String encryptAuthData(AuthData auth) throws IllegalBlockSizeException, BadPaddingException {
        byte[] bytes = encryptCipher.doFinal(auth.getBytes());
        return DatatypeConverter.printBase64Binary((byte[])bytes);
    }

    public Response toJSON(Object data) {
        String childPathDataJSON;
        try {
            childPathDataJSON = this.mapper.writeValueAsString(data);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Problem building response JSON: ", e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.ok((Object)childPathDataJSON).build();
    }

    public void checkAuthCookie(Cookie authCookie) {
        if (authCookie == null) {
            this.checkAuthData(null);
        } else {
            this.checkAuthData(authCookie.getValue());
        }
    }

    public AgentPath checkAuthData(String authData) {
        if (!this.requireLogin) {
            return null;
        }
        if (authData == null) {
            throw ItemUtils.createWebAppException("Missing authentication data", Response.Status.UNAUTHORIZED);
        }
        try {
            AuthData data = this.decryptAuthData(authData);
            return data.agent;
        }
        catch (InvalidDataException | InvalidAgentPathException e) {
            throw ItemUtils.createWebAppException("Invalid agent or login data", (Exception)e, Response.Status.UNAUTHORIZED);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Error reading authentication data", e, Response.Status.UNAUTHORIZED);
        }
    }

    public AgentProxy getAgent(String agentName, Cookie authCookie) {
        if (authCookie == null) {
            return this.getAgent(agentName, (String)null);
        }
        return this.getAgent(agentName, authCookie.getValue());
    }

    public AgentProxy getAgent(String agentName, String authData) {
        AgentPath agentPath = this.checkAuthData(authData);
        try {
            if (agentPath == null) {
                if (agentName != null && !"".equals(agentName)) {
                    agentPath = Gateway.getLookup().getAgentPath(agentName);
                } else {
                    throw ItemUtils.createWebAppException("Agent is empty", Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            return (AgentProxy)Gateway.getProxyManager().getProxy((Path)agentPath);
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Agent not found", (Exception)((Object)e), Response.Status.NOT_FOUND);
        }
    }

    public class AuthData {
        AgentPath agent;
        Date timestamp;

        public AuthData(AgentPath agent) {
            this.agent = agent;
            this.timestamp = new Date();
        }

        public AuthData(byte[] bytes) throws InvalidAgentPathException, InvalidDataException {
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            SystemKey sysKey = new SystemKey(buf.getLong(), buf.getLong());
            this.agent = new AgentPath(new ItemPath(sysKey));
            this.timestamp = new Date(buf.getLong());
            int cookieLife = Gateway.getProperties().getInt("REST.loginCookieLife", 0);
            if (cookieLife > 0 && (new Date().getTime() - this.timestamp.getTime()) / 1000L > (long)cookieLife) {
                throw new InvalidDataException("Cookie too old");
            }
        }

        public byte[] getBytes() {
            byte[] bytes = new byte[192];
            SystemKey sysKey = this.agent.getSystemKey();
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            buf.putLong(sysKey.msb);
            buf.putLong(sysKey.lsb);
            buf.putLong(this.timestamp.getTime());
            return bytes;
        }
    }
}

