/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.net.URI;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.RestHandler;

@Path(value="/role")
public class RoleAccess
extends RestHandler {
    @GET
    @Produces(value={"application/json"})
    public Response listRoles(@CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        LinkedHashMap<String, UriBuilder> roles = new LinkedHashMap<String, UriBuilder>();
        Iterator iter = Gateway.getLookup().search((org.cristalise.kernel.lookup.Path)new RolePath(), "*");
        while (iter.hasNext()) {
            RolePath role = (RolePath)iter.next();
            roles.put(role.getName(), uri.getAbsolutePathBuilder().path(role.getName()));
        }
        return this.toJSON(roles);
    }

    @GET
    @Path(value="{role}")
    @Produces(value={"application/json"})
    public Response getRole(@PathParam(value="role") String roleName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        AgentPath[] agents;
        RolePath role;
        this.checkAuthCookie(authCookie);
        try {
            role = Gateway.getLookup().getRolePath(roleName);
        }
        catch (ObjectNotFoundException e1) {
            throw ItemUtils.createWebAppException(e1.getMessage(), Response.Status.NOT_FOUND);
        }
        LinkedHashMap<String, Object> roleData = new LinkedHashMap<String, Object>();
        roleData.put("name", roleName);
        roleData.put("hasJobList", role.hasJobList());
        Iterator childRoles = Gateway.getLookup().getChildren((org.cristalise.kernel.lookup.Path)role);
        if (childRoles.hasNext()) {
            LinkedHashMap<String, URI> childRoleData = new LinkedHashMap<String, URI>();
            while (childRoles.hasNext()) {
                RolePath childRole = (RolePath)childRoles.next();
                childRoleData.put(childRole.getName(), uri.getBaseUriBuilder().path("role").path(childRole.getName()).build(new Object[0]));
            }
            roleData.put("subroles", childRoleData);
        }
        try {
            agents = Gateway.getLookup().getAgents(role);
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.NOT_FOUND);
        }
        if (agents.length > 0) {
            LinkedHashMap<String, URI> agentData = new LinkedHashMap<String, URI>();
            for (AgentPath agent : agents) {
                agentData.put(agent.getAgentName(), uri.getBaseUriBuilder().path("item").path(agent.getUUID().toString()).build(new Object[0]));
            }
            roleData.put("agents", agentData);
        }
        return this.toJSON(roleData);
    }
}

