/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.util.LinkedHashMap;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.restapi.ItemRoot;
import org.cristalise.restapi.ItemUtils;

@Path(value="/item/{uuid}/viewpoint")
public class ItemViewpoint
extends ItemUtils {
    @GET
    @Produces(value={"application/json"})
    public Response getSchemas(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        return this.toJSON(this.enumerate(item, ClusterType.VIEWPOINT, "viewpoint", uri));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}")
    public Response getViewNames(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        return this.toJSON(this.enumerate(item, ClusterType.VIEWPOINT + "/" + schema, "viewpoint/" + schema, uri));
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="{schema}/{viewName}")
    public Response queryXMLData(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="viewName") String viewName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        return this.getViewpointOutcome(uuid, schema, viewName, false);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}/{viewName}")
    public Response queryJSONData(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="viewName") String viewName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        return this.getViewpointOutcome(uuid, schema, viewName, true);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}/{viewName}/event")
    public Response getViewEvent(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="viewName") String viewName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        Event ev;
        Viewpoint view;
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        try {
            view = item.getViewpoint(schema, viewName);
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Database error loading view " + viewName + " of schema " + schema);
        }
        try {
            ev = view.getEvent();
        }
        catch (InvalidDataException | ObjectNotFoundException | PersistencyException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Database error loading event data for view " + viewName + " of schema " + schema);
        }
        return this.toJSON(this.makeEventData(ev, uri));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}/{viewName}/history")
    public Response getAllEventsForView(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="viewName") String viewName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        History history;
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        try {
            history = (History)item.getObject(ClusterType.HISTORY);
            history.activate();
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException("Could not load History");
        }
        LinkedHashMap eventList = new LinkedHashMap();
        for (int i = 0; i <= history.getLastId(); ++i) {
            Event ev = (Event)history.get((Object)i);
            if (!schema.equals(ev.getSchemaName()) || !viewName.equals(ev.getViewName())) continue;
            String evId = String.valueOf(i);
            LinkedHashMap<String, Object> eventDetails = new LinkedHashMap<String, Object>();
            eventDetails.put("timestamp", ev.getTimeString());
            eventDetails.put("data", uri.getAbsolutePathBuilder().path(evId).build(new Object[0]));
            eventList.put(evId, eventDetails);
        }
        return this.toJSON(eventList);
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="{schema}/{viewName}/history/{event}")
    public Response getOutcomeForEvent(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="viewName") String viewName, @PathParam(value="event") Integer eventId, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        Outcome oc;
        Event ev;
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        try {
            ev = (Event)item.getObject(ClusterType.HISTORY + "/" + eventId);
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException("Event " + eventId + " was not found", Response.Status.NOT_FOUND);
        }
        if (!schema.equals(ev.getSchemaName()) || !viewName.equals(ev.getViewName())) {
            throw ItemUtils.createWebAppException("Event does not belong to this data", Response.Status.BAD_REQUEST);
        }
        try {
            oc = (Outcome)item.getObject(ClusterType.OUTCOME + "/" + schema + "/" + ev.getSchemaVersion() + "/" + eventId);
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException("Outcome " + eventId + " was not found", Response.Status.NOT_FOUND);
        }
        return this.getOutcomeResponse(oc, ev, false);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}/{viewName}/history/{event}/event")
    public Response getOutcomeEvent(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="viewName") String viewName, @PathParam(value="event") Integer eventId, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        Event ev;
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        try {
            ev = (Event)item.getObject(ClusterType.HISTORY + "/" + eventId);
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException("Event " + eventId + " was not found", Response.Status.NOT_FOUND);
        }
        if (!schema.equals(ev.getSchemaName()) || !viewName.equals(ev.getViewName())) {
            throw ItemUtils.createWebAppException("Event does not belong to this data", Response.Status.BAD_REQUEST);
        }
        return this.toJSON(this.makeEventData(ev, uri));
    }
}

