/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.restapi.ItemRoot;
import org.cristalise.restapi.ItemUtils;

@Path(value="/item/{uuid}/attachment")
public class ItemOutcomeAttachment
extends ItemUtils {
    @GET
    @Produces(value={"application/json"})
    public Response getOutcomeSchemas(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        return this.toJSON(this.enumerate(item, ClusterType.ATTACHMENT, "attachment", uri));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}")
    public Response getOutcomeVersions(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        return this.toJSON(this.enumerate(item, ClusterType.ATTACHMENT + "/" + schema, "attachment/" + schema, uri));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}/{version}")
    public Response getOutcomeEvents(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="version") Integer version, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        return this.toJSON(this.enumerate(item, ClusterType.ATTACHMENT + "/" + schema + "/" + version, "attachment/" + schema + "/" + version, uri));
    }

    @GET
    @Produces(value={"text/plain", "text/xml", "application/xml"})
    @Path(value="{schema}/{version}/{event}")
    public Response queryXMLData(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="version") Integer version, @PathParam(value="event") Integer event, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        return this.getOutcome(uuid, schema, version, event, false);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}/{version}/{event}")
    public Response queryJSONData(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="version") Integer version, @PathParam(value="event") Integer event, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        return this.getOutcome(uuid, schema, version, event, true);
    }
}

