/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.util.LinkedHashMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.RemoteMap;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.restapi.ItemUtils;

public class RemoteMapAccess {
    private RemoteMapAccess() {
    }

    public static LinkedHashMap<String, Object> list(ItemProxy item, ClusterType root, int start, int batchSize, UriInfo uri) {
        int i;
        RemoteMap map;
        try {
            map = (RemoteMap)item.getObject(root);
            map.activate();
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Could not access item history");
        }
        catch (ClassCastException e) {
            throw ItemUtils.createWebAppException("Object was not a RemoteMap: " + root, Response.Status.BAD_REQUEST);
        }
        LinkedHashMap<String, Object> batch = new LinkedHashMap<String, Object>();
        int last = map.getLastId();
        for (i = start; batch.size() < batchSize && i <= last; ++i) {
            C2KLocalObject obj = map.get((Object)i);
            if (obj == null) continue;
            batch.put(String.valueOf(i), obj);
        }
        if (i < last) {
            while (map.get((Object)i) == null) {
                ++i;
            }
            batch.put("nextBatch", uri.getAbsolutePathBuilder().replaceQueryParam("start", new Object[]{i}).replaceQueryParam("batch", new Object[]{batchSize}).build(new Object[0]));
        }
        return batch;
    }

    public static C2KLocalObject get(ItemProxy item, ClusterType root, String id) {
        RemoteMap map;
        try {
            map = (RemoteMap)item.getObject(root);
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (ClassCastException e) {
            throw ItemUtils.createWebAppException("Object was not a RemoteMap: " + root, Response.Status.BAD_REQUEST);
        }
        if (id.equals("last")) {
            id = String.valueOf(map.getLastId());
        }
        if (map.containsKey((Object)id)) {
            return map.get((Object)id);
        }
        throw ItemUtils.createWebAppException("Object was not found in " + root + " id:" + id, Response.Status.NOT_FOUND);
    }
}

