/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.restapi.ResourceAccess;

@Path(value="/stateMachine")
public class StateMachineAccess
extends ResourceAccess {
    @GET
    @Produces(value={"application/json"})
    public Response listAllStateMachines(@DefaultValue(value="0") @QueryParam(value="start") Integer start, @QueryParam(value="batch") Integer batchSize, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        if (batchSize == null) {
            batchSize = Gateway.getProperties().getInt("REST.DefaultBatchSize", 75);
        }
        return this.listAllResources(BuiltInResources.STATE_MACHINE_RESOURCE, uri, start, batchSize);
    }

    @GET
    @Path(value="{name}")
    @Produces(value={"application/json"})
    public Response listStateMachineVersions(@PathParam(value="name") String name, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        return this.listResourceVersions(BuiltInResources.STATE_MACHINE_RESOURCE, name, uri);
    }

    @GET
    @Path(value="{name}/{version}")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getStateMachine(@Context HttpHeaders headers, @PathParam(value="name") String name, @PathParam(value="version") Integer version, @CookieParam(value="cauth") Cookie authCookie) {
        this.checkAuthCookie(authCookie);
        return this.getResource(BuiltInResources.STATE_MACHINE_RESOURCE, name, version, StateMachineAccess.produceJSON(headers.getAcceptableMediaTypes()));
    }
}

