/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.RestHandler;

public class PathUtils
extends RestHandler {
    protected Map<String, Object> makeLookupData(String path, Path nextPath, UriInfo uri) {
        String name = nextPath.getName();
        String type = "n/a";
        String domainPath = "";
        URI nextPathURI = null;
        UUID uuid = null;
        Boolean hasJoblist = null;
        if (nextPath instanceof DomainPath) {
            type = "domain";
            DomainPath nextDom = (DomainPath)nextPath;
            domainPath = nextDom.getStringPath();
            try {
                ItemPath nextItem = nextDom.getItemPath();
                type = "item";
                nextPathURI = ItemUtils.getItemURI(uri, nextItem.getUUID(), new Object[0]);
                uuid = nextItem.getUUID();
            }
            catch (ObjectNotFoundException ex) {
                nextPathURI = uri.getAbsolutePathBuilder().path(nextDom.getName()).build(new Object[0]);
            }
        } else if (nextPath instanceof ItemPath) {
            type = "item";
            if (nextPath instanceof AgentPath) {
                type = "agent";
            }
            ItemPath itemPath = (ItemPath)nextPath;
            uuid = itemPath.getUUID();
            try {
                name = Gateway.getProxyManager().getProxy((Path)itemPath).getName();
            }
            catch (ObjectNotFoundException e) {
                name = itemPath.getUUID().toString();
            }
            nextPathURI = ItemUtils.getItemURI(uri, itemPath, new Object[0]);
        } else if (nextPath instanceof RolePath) {
            type = "role";
            hasJoblist = ((RolePath)nextPath).hasJobList();
            nextPathURI = uri.getAbsolutePathBuilder().path(nextPath.getName()).build(new Object[0]);
        }
        LinkedHashMap<String, Object> childPathData = new LinkedHashMap<String, Object>();
        childPathData.put("name", name);
        childPathData.put("type", type);
        childPathData.put("url", nextPathURI);
        if (StringUtils.isNotBlank((CharSequence)domainPath)) {
            childPathData.put("path", domainPath);
        } else if (path.equals("/") || StringUtils.isBlank((CharSequence)path)) {
            childPathData.put("path", "/" + name);
        } else {
            childPathData.put("path", "/" + path + "/" + name);
        }
        if (uuid != null) {
            childPathData.put("uuid", uuid);
        }
        if (hasJoblist != null) {
            childPathData.put("hasJoblist", hasJoblist);
        }
        return childPathData;
    }
}

