/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcomebuilder.OutcomeBuilder;
import org.cristalise.kernel.persistency.outcomebuilder.OutcomeBuilderException;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.ResourceAccess;

@Path(value="/schema")
public class SchemaAccess
extends ResourceAccess {
    @GET
    @Produces(value={"application/json"})
    public Response listAllSchemas(@DefaultValue(value="0") @QueryParam(value="start") Integer start, @QueryParam(value="batch") Integer batchSize, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        if (batchSize == null) {
            batchSize = Gateway.getProperties().getInt("REST.DefaultBatchSize", 75);
        }
        return this.listAllResources(BuiltInResources.SCHEMA_RESOURCE, uri, start, batchSize);
    }

    @GET
    @Path(value="{name}")
    @Produces(value={"application/json"})
    public Response listSchemaVersions(@PathParam(value="name") String name, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        return this.listResourceVersions(BuiltInResources.SCHEMA_RESOURCE, name, uri);
    }

    @GET
    @Path(value="{name}/{version}")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getSchema(@Context HttpHeaders headers, @PathParam(value="name") String name, @PathParam(value="version") Integer version, @CookieParam(value="cauth") Cookie authCookie) {
        this.checkAuthCookie(authCookie);
        return this.getResource(BuiltInResources.SCHEMA_RESOURCE, name, version, SchemaAccess.produceJSON(headers.getAcceptableMediaTypes()));
    }

    @GET
    @Path(value="{name}/{version}/formTemplate")
    @Produces(value={"application/json"})
    public Response getSchemaFormTemplate(@Context HttpHeaders headers, @PathParam(value="name") String name, @PathParam(value="version") Integer version, @CookieParam(value="cauth") Cookie authCookie) {
        this.checkAuthCookie(authCookie);
        try {
            Schema schema = LocalObjectLoader.getSchema((String)name, (int)version);
            return Response.ok((Object)new OutcomeBuilder(schema, false).generateNgDynamicForms()).build();
        }
        catch (InvalidDataException | ObjectNotFoundException | OutcomeBuilderException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Schema " + name + " v" + version + " doesn't point to any data", (Exception)e, Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Schema " + name + " v" + version, e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="{name}/{version}/viewTemplate")
    @Produces(value={"application/json"})
    public Response getSchemaViewTemplate(@Context HttpHeaders headers, @PathParam(value="name") String name, @PathParam(value="version") Integer version, @CookieParam(value="cauth") Cookie authCookie) {
        this.checkAuthCookie(authCookie);
        try {
            Schema schema = LocalObjectLoader.getSchema((String)name, (int)version);
            return Response.ok((Object)new OutcomeBuilder(schema).exportViewTemplate()).build();
        }
        catch (InvalidDataException | ObjectNotFoundException | OutcomeBuilderException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Schema " + name + " v" + version + " doesn't point to any data", Response.Status.NOT_FOUND);
        }
    }
}

