/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.util.Base64;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.security.SecurityManager;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.RestHandler;
import org.json.JSONObject;
import org.json.XML;

@Path(value="login")
public class CookieLogin
extends RestHandler {
    @GET
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response login(@Context HttpHeaders headers, @QueryParam(value="user") String user, @QueryParam(value="pass") String pass) {
        return this.processLogin(user, pass, headers);
    }

    private Response processLogin(String user, String pass, HttpHeaders headers) {
        try {
            AgentPath agentPath = Gateway.getSecurityManager().authenticate(user, pass, null).getPath();
            return this.getCookieResponse(agentPath, ItemUtils.produceJSON(headers.getAcceptableMediaTypes()));
        }
        catch (InvalidDataException | ObjectNotFoundException ex) {
            String msg = SecurityManager.decodePublicSecurityMessage((Throwable)ex);
            if (StringUtils.isBlank((CharSequence)msg)) {
                msg = "Bad username/password";
            }
            Logger.msg((int)5, (String)"CookieLogin.login() - %s", (Object[])new Object[]{msg});
            throw ItemUtils.createWebAppException(msg, Response.Status.UNAUTHORIZED);
        }
    }

    private synchronized Response getCookieResponse(AgentPath agentPath, boolean produceJSON) {
        RestHandler.AuthData agentData = (RestHandler)this.new RestHandler.AuthData(agentPath);
        try {
            NewCookie cookie = new NewCookie("cauth", this.encryptAuthData(agentData));
            boolean tempPwd = Gateway.getLookup().getAgentPath(agentPath.getAgentName()).isPasswordTemporary();
            String result = "<Login result='Success' temporaryPassword='" + tempPwd + "' />";
            if (produceJSON) {
                result = XML.toJSONObject((String)result, (boolean)true).toString();
            }
            return Response.ok((Object)result).cookie(new NewCookie[]{cookie}).build();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Error creating cookie");
        }
    }

    @POST
    @Consumes(value={"text/plain", "text/xml", "application/xml", "application/json"})
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response postLogin(String postData, @Context HttpHeaders headers) {
        String pass;
        String user;
        try {
            if (StringUtils.isEmpty((CharSequence)postData)) {
                throw new Exception("Authentication data is null or empty");
            }
            JSONObject authData = new JSONObject(postData);
            user = this.decode(authData.getString("username"));
            pass = this.decode(authData.getString("password"));
            if (StringUtils.isEmpty((CharSequence)user) || StringUtils.isEmpty((CharSequence)pass)) {
                throw new Exception("Invalid username or password");
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Problem logging in", Response.Status.BAD_REQUEST);
        }
        return this.processLogin(user, pass, headers);
    }

    private String decode(String encodedStr) {
        return new String(Base64.getDecoder().decode(encodedStr));
    }
}

