/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.RemoteMapAccess;

@Path(value="/item/{uuid}/history")
public class ItemHistory
extends ItemUtils {
    @GET
    @Produces(value={"application/json"})
    public Response listEvents(@PathParam(value="uuid") String uuid, @QueryParam(value="start") Integer start, @QueryParam(value="batch") Integer batchSize, @QueryParam(value="descending") Boolean descending, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemHistory.getProxy(uuid);
        if (start == null) {
            start = 0;
        }
        descending = descending != null;
        if (batchSize == null) {
            batchSize = Gateway.getProperties().getInt("REST.Event.DefaultBatchSize", Gateway.getProperties().getInt("REST.DefaultBatchSize", 20));
        }
        LinkedHashMap<String, Object> batch = RemoteMapAccess.list(item, ClusterType.HISTORY, start, batchSize, descending, uri);
        ArrayList<LinkedHashMap<String, Object>> events = new ArrayList<LinkedHashMap<String, Object>>();
        for (String key : batch.keySet()) {
            Object obj = batch.get(key);
            if (!(obj instanceof Event)) continue;
            events.add(this.makeEventData((Event)obj, uri));
        }
        return this.toJSON(events);
    }

    @GET
    @Path(value="{eventId}")
    @Produces(value={"application/json"})
    public Response getEvent(@PathParam(value="uuid") String uuid, @PathParam(value="eventId") String eventId, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemHistory.getProxy(uuid);
        Event ev = (Event)RemoteMapAccess.get(item, ClusterType.HISTORY, eventId);
        return this.toJSON(this.makeEventData(ev, uri));
    }

    private Response getEventOutcome(String uuid, String eventId, Cookie authCookie, UriInfo uri, boolean json) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemHistory.getProxy(uuid);
        Event ev = (Event)RemoteMapAccess.get(item, ClusterType.HISTORY, eventId);
        if (ev.getSchemaName() == null || ev.getSchemaName().equals("")) {
            throw ItemUtils.createWebAppException("This event has no data", Response.Status.NOT_FOUND);
        }
        try {
            Outcome oc = (Outcome)item.getObject(ClusterType.OUTCOME + "/" + ev.getSchemaName() + "/" + ev.getSchemaVersion() + "/" + ev.getID());
            return this.getOutcomeResponse(oc, ev, json);
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException("Referenced data not found", Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="{eventId}/data")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getEventOutcome(@Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @PathParam(value="eventId") String eventId, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        return this.getEventOutcome(uuid, eventId, authCookie, uri, ItemHistory.produceJSON(headers.getAcceptableMediaTypes()));
    }
}

