/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lifecycle.instance.predefined.agent.ForcedLogout;
import org.cristalise.kernel.lifecycle.instance.predefined.agent.LoginTimeout;
import org.cristalise.kernel.lifecycle.instance.predefined.agent.Logout;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.RestHandler;

@Path(value="logout")
public class CookieLogout
extends RestHandler {
    @GET
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response logout(@Context HttpHeaders headers, @QueryParam(value="reason") String reason, @CookieParam(value="cauth") Cookie authCookie) {
        AgentPath ap = this.checkAuthCookie(authCookie);
        Logger.msg((int)5, (String)"CookieLogout() - agent:'%s' reason:'%s'", (Object[])new Object[]{ap.getAgentName(), reason});
        try {
            AgentProxy agent = Gateway.getProxyManager().getAgentProxy(ap);
            if ("timeout".equals(reason)) {
                agent.execute((ItemProxy)agent, LoginTimeout.class);
            } else if ("windowClose".equals(reason)) {
                agent.execute((ItemProxy)agent, ForcedLogout.class);
            } else {
                agent.execute((ItemProxy)agent, Logout.class);
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Problem logging out", Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.ok().build();
    }
}

