/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcomebuilder.OutcomeBuilder;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.ScriptUtils;

@javax.ws.rs.Path(value="/item/{uuid}/collection")
public class ItemCollection
extends ItemUtils {
    private ScriptUtils scriptUtils = new ScriptUtils();

    @GET
    @Produces(value={"application/json"})
    public Response getCollections(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemCollection.getProxy(uuid);
        return this.toJSON(this.enumerate(item, ClusterType.COLLECTION, "collection", uri));
    }

    @GET
    @javax.ws.rs.Path(value="{name}")
    @Produces(value={"application/json"})
    public Response getLastCollection(@PathParam(value="uuid") String uuid, @PathParam(value="name") String collName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemCollection.getProxy(uuid);
        try {
            return this.toJSON(this.makeCollectionData(item.getCollection(collName), uri));
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.NOT_FOUND);
        }
    }

    @GET
    @javax.ws.rs.Path(value="{name}/version")
    public Response getCollectionVersions(@PathParam(value="uuid") String uuid, @PathParam(value="name") String collName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemCollection.getProxy(uuid);
        return this.toJSON(this.enumerate(item, ClusterType.COLLECTION + "/" + collName, "collection/" + collName + "/version", uri));
    }

    @GET
    @javax.ws.rs.Path(value="{name}/version/{version}")
    public Response getCollectionVersion(@PathParam(value="uuid") String uuid, @PathParam(value="name") String collName, @PathParam(value="version") String collVersion, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemCollection.getProxy(uuid);
        try {
            return this.toJSON(this.makeCollectionData(item.getCollection(collName, collVersion.equals("last") ? null : Integer.valueOf(collVersion)), uri));
        }
        catch (NumberFormatException | ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.NOT_FOUND);
        }
    }

    @GET
    @javax.ws.rs.Path(value="{name}/formTemplate")
    @Produces(value={"application/json"})
    public Response getCollectionUpdateFormTemplate(@PathParam(value="uuid") String uuid, @PathParam(value="name") String collName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        AgentProxy agent = null;
        try {
            agent = (AgentProxy)Gateway.getProxyManager().getProxy((Path)this.checkAuthCookie(authCookie));
        }
        catch (ObjectNotFoundException e1) {
            throw ItemUtils.createWebAppException(e1.getMessage(), Response.Status.UNAUTHORIZED);
        }
        ItemProxy item = ItemCollection.getProxy(uuid);
        try {
            String[] lovInfo;
            Dependency dep = (Dependency)item.getCollection(collName);
            HashMap<String, Object> inputs = new HashMap<String, Object>();
            String lovProp = (String)dep.getProperties().get((Object)"ListOfValues");
            if (StringUtils.isNotBlank((CharSequence)lovProp) && "ScriptRef".equals((lovInfo = lovProp.split(":"))[0])) {
                Script script = LocalObjectLoader.getScript((String)lovInfo[1], (int)Integer.valueOf(lovInfo[2]));
                Map result = (Map)this.scriptUtils.executeScript(item, script, null);
                result.remove(null);
                TreeMap valuesToCaptions = new TreeMap(result);
                inputs.put("memberNames", valuesToCaptions);
            }
            if (inputs.isEmpty()) {
                List<String> names = ItemCollection.getItemNames(dep.getClassProperties());
                if (Gateway.getProperties().getBoolean("REST.CollectionForm.checkInputs", false) && names.size() == 0) {
                    throw ItemUtils.createWebAppException("No Item was found", Response.Status.NOT_FOUND);
                }
                inputs.put("memberNames", names);
            }
            inputs.put("agent", agent);
            inputs.put("item", item);
            String[] schemaInfo = ((String)dep.getProperties().get((Object)"MemberUpdateSchema")).split(":");
            Schema schema = LocalObjectLoader.getSchema((String)schemaInfo[0], (int)Integer.valueOf(schemaInfo[1]));
            return Response.ok((Object)new OutcomeBuilder(schema, false).generateNgDynamicForms(inputs)).build();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), e, Response.Status.NOT_FOUND);
        }
    }
}

