/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.util.LinkedHashMap;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.property.Property;
import org.cristalise.restapi.ItemUtils;

@Path(value="/item/{uuid}/property")
public class ItemProperty
extends ItemUtils {
    @GET
    @Produces(value={"application/json"})
    public Response listProperties(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie) {
        this.checkAuthCookie(authCookie);
        try {
            return this.toJSON(ItemProperty.getPropertySummary(ItemProperty.getProxy(uuid)));
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="{name}")
    @Produces(value={"text/plain"})
    public String getProperty(@PathParam(value="uuid") String uuid, @PathParam(value="name") String name, @CookieParam(value="cauth") Cookie authCookie) {
        this.checkAuthCookie(authCookie);
        try {
            return ItemProperty.getProxy(uuid).getProperty(name);
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="{name}/details")
    @Produces(value={"application/json"})
    public Response getPropertyDetails(@PathParam(value="uuid") String uuid, @PathParam(value="name") String name, @CookieParam(value="cauth") Cookie authCookie) {
        this.checkAuthCookie(authCookie);
        LinkedHashMap<String, Object> propDetails = new LinkedHashMap<String, Object>();
        try {
            Property prop = (Property)ItemProperty.getProxy(uuid).getObject(ClusterType.PROPERTY + "/" + name);
            propDetails.put("name", prop.getName());
            propDetails.put("value", prop.getValue());
            propDetails.put("readOnly", !prop.isMutable());
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.NOT_FOUND);
        }
        return this.toJSON(propDetails);
    }
}

