/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.OutcomeAttachment;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcomebuilder.OutcomeBuilder;
import org.cristalise.kernel.persistency.outcomebuilder.OutcomeBuilderException;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptErrorException;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.ScriptUtils;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.json.XML;

@javax.ws.rs.Path(value="/item/{uuid}")
public class ItemRoot
extends ItemUtils {
    private ScriptUtils scriptUtils = new ScriptUtils();

    @GET
    @javax.ws.rs.Path(value="name")
    @Produces(value={"text/plain"})
    public String getName(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie) {
        this.checkAuthCookie(authCookie);
        String name = this.getItemName(new ItemPath(UUID.fromString(uuid)));
        if (StringUtils.isBlank((CharSequence)name)) {
            throw ItemUtils.createWebAppException("Cannot resolve UUID", Response.Status.NOT_FOUND);
        }
        return name;
    }

    @GET
    @javax.ws.rs.Path(value="aliases")
    @Produces(value={"application/json"})
    public Response getAliases(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie) {
        this.checkAuthCookie(authCookie);
        Map<String, Object> itemAliases = this.makeItemDomainPathsData(new ItemPath(UUID.fromString(uuid)));
        if (StringUtils.isBlank((CharSequence)((String)itemAliases.get("name")))) {
            throw ItemUtils.createWebAppException("Cannot resolve UUID", Response.Status.NOT_FOUND);
        }
        return this.toJSON(itemAliases);
    }

    @GET
    @javax.ws.rs.Path(value="master")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getMasterOutcome(@Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @QueryParam(value="script") String scriptName, @QueryParam(value="scriptVersion") Integer scriptVersion, @CookieParam(value="cauth") Cookie authCookie) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        String type = item.getType();
        if (type == null) {
            throw ItemUtils.createWebAppException("Type is null, cannot get MasterOutcome ", Response.Status.NOT_FOUND);
        }
        String view = "last";
        int schemaVersion = 0;
        if (scriptVersion == null) {
            scriptVersion = 0;
        }
        Script script = null;
        try {
            if (scriptName != null) {
                Schema schema = LocalObjectLoader.getSchema((String)type, (int)schemaVersion);
                script = LocalObjectLoader.getScript((String)scriptName, (int)scriptVersion);
                return this.scriptUtils.returnScriptResult(scriptName, item, schema, script, new CastorHashMap(), ItemRoot.produceJSON(headers.getAcceptableMediaTypes()));
            }
            script = this.getAggregateScript(type, scriptVersion);
            if (script != null) {
                Schema schema = LocalObjectLoader.getSchema((String)type, (int)schemaVersion);
                return this.scriptUtils.returnScriptResult(scriptName, item, schema, script, new CastorHashMap(), ItemRoot.produceJSON(headers.getAcceptableMediaTypes()));
            }
            if (item.checkViewpoint(type, view)) {
                return this.getViewpointOutcome(uuid, type, view, true);
            }
            throw ItemUtils.createWebAppException("No method available to retrieve MasterOutcome", Response.Status.NOT_FOUND);
        }
        catch (InvalidDataException | ObjectNotFoundException | ScriptingEngineException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Error retrieving MasterOutcome:" + e.getMessage(), (Exception)e, Response.Status.NOT_FOUND);
        }
    }

    @GET
    @javax.ws.rs.Path(value="scriptResult")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getScriptResult(@Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @QueryParam(value="script") String scriptName, @QueryParam(value="version") Integer scriptVersion, @QueryParam(value="inputs") String inputJson, @CookieParam(value="cauth") Cookie authCookie) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        return this.scriptUtils.executeScript(headers, item, scriptName, scriptVersion, inputJson, (Map<String, Object>)ImmutableMap.of());
    }

    @POST
    @javax.ws.rs.Path(value="scriptResult")
    @Consumes(value={"text/xml", "application/xml", "application/json", "text/plain"})
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getScriptResultPost(String postData, @Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @QueryParam(value="script") String scriptName, @QueryParam(value="version") Integer scriptVersion, @CookieParam(value="cauth") Cookie authCookie) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        return this.scriptUtils.executeScript(headers, item, scriptName, scriptVersion, postData, (Map<String, Object>)ImmutableMap.of());
    }

    @GET
    @javax.ws.rs.Path(value="queryResult")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getQueryResult(@Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @QueryParam(value="query") String queryName, @QueryParam(value="version") Integer queryVersion, @CookieParam(value="cauth") Cookie authCookie) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        if (queryVersion == null) {
            queryVersion = 0;
        }
        Query query = null;
        try {
            if (queryName != null) {
                query = LocalObjectLoader.getQuery((String)queryName, (int)queryVersion);
                return this.returnQueryResult(queryName, item, null, query, ItemRoot.produceJSON(headers.getAcceptableMediaTypes()));
            }
            throw ItemUtils.createWebAppException("Name or UUID of Query was missing", Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Error executing Query:" + e.getMessage(), e, Response.Status.NOT_FOUND);
        }
    }

    private Response returnQueryResult(String queryName, ItemProxy item, Object object, Query query, boolean jsonFlag) throws PersistencyException {
        String xmlResult = item.executeQuery(query);
        if (jsonFlag) {
            return Response.ok((Object)XML.toJSONObject((String)xmlResult, (boolean)true).toString()).build();
        }
        return Response.ok((Object)xmlResult).build();
    }

    private Script getAggregateScript(String type, Integer scriptVersion) {
        String scriptName = type + Gateway.getProperties().getString("REST.MasterOutcome.postfix", "_Aggregate");
        try {
            return LocalObjectLoader.getScript((String)scriptName, (int)scriptVersion);
        }
        catch (InvalidDataException | ObjectNotFoundException e1) {
            Logger.msg((int)5, (String)"ItemRoot.getAggregateScript() - Could not find Script name:%s", (Object[])new Object[]{scriptName});
            return null;
        }
    }

    @GET
    @Produces(value={"application/json"})
    public Response getItemSummary(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        Map<String, Object> itemSummary = this.makeItemDomainPathsData(item.getPath());
        itemSummary.put("uuid", uuid);
        itemSummary.put("hasMasterOutcome", false);
        try {
            String type = item.getType();
            if (type != null) {
                itemSummary.put("type", type);
                if (this.getAggregateScript(type, 0) != null || item.checkViewpoint(type, "last")) {
                    itemSummary.put("hasMasterOutcome", true);
                    itemSummary.put("master", ItemRoot.getItemURI(uri, item, new Object[]{"master"}));
                }
            }
            itemSummary.put("properties", ItemRoot.getPropertySummary(item));
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("No Properties found", (Exception)((Object)e), Response.Status.BAD_REQUEST);
        }
        itemSummary.put("viewpoints", this.getAllViewpoints(item, uri));
        itemSummary.put("collections", this.enumerate(item, ClusterType.COLLECTION, "collection", uri));
        itemSummary.put("workflow", ItemRoot.getItemURI(uri, item, new Object[]{"workflow"}));
        itemSummary.put("history", ItemRoot.getItemURI(uri, item, new Object[]{"history"}));
        itemSummary.put("outcome", ItemRoot.getItemURI(uri, item, new Object[]{"outcome"}));
        return this.toJSON(itemSummary);
    }

    @GET
    @javax.ws.rs.Path(value="job")
    @Produces(value={"application/json"})
    public Response getJobs(@PathParam(value="uuid") String uuid, @QueryParam(value="agent") String agentName, @QueryParam(value="activityName") String activityName, @QueryParam(value="transitionName") String transitionName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ItemProxy item = ItemRoot.getProxy(uuid);
        AgentProxy agent = this.getAgent(agentName, authCookie);
        ArrayList jobList = null;
        Job job = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)activityName)) {
                job = StringUtils.isNotBlank((CharSequence)transitionName) ? item.getJobByTransitionName(activityName, transitionName, agent) : item.getJobByName(activityName, agent);
            } else {
                jobList = item.getJobList(agent);
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Error loading joblist");
        }
        String itemName = item.getName();
        if (jobList != null) {
            ArrayList<LinkedHashMap<String, Object>> jobListData = new ArrayList<LinkedHashMap<String, Object>>();
            for (Job j : jobList) {
                jobListData.add(this.makeJobData(j, itemName, uri));
            }
            return this.toJSON(jobListData);
        }
        if (job != null) {
            return this.toJSON(this.makeJobData(job, itemName, uri));
        }
        throw ItemUtils.createWebAppException("No job found for actName:" + activityName + " transName:" + transitionName, Response.Status.NOT_FOUND);
    }

    @POST
    @Consumes(value={"text/plain", "text/xml", "application/xml", "application/json"})
    @Produces(value={"text/xml", "application/xml", "application/json"})
    @javax.ws.rs.Path(value="{activityPath: .*}")
    public String requestTransition(String postData, @Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @PathParam(value="activityPath") String actPath, @QueryParam(value="transition") String transition, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        AgentProxy agent = null;
        try {
            agent = (AgentProxy)Gateway.getProxyManager().getProxy((Path)this.checkAuthCookie(authCookie));
        }
        catch (ObjectNotFoundException e1) {
            throw ItemUtils.createWebAppException(e1.getMessage(), Response.Status.UNAUTHORIZED);
        }
        if (actPath == null) {
            throw ItemUtils.createWebAppException("Must specify activity path", Response.Status.BAD_REQUEST);
        }
        ItemProxy item = ItemRoot.getProxy(uuid);
        try {
            List types = headers.getRequestHeader("Content-Type");
            Logger.msg((int)5, (String)"ItemRoot.requestTransition() postData:%s", (Object[])new Object[]{postData});
            if (actPath.startsWith("workflow/predefined/")) {
                return this.executePredefinedStep(item, postData, types, actPath, agent);
            }
            transition = this.extractAndCcheckTransitionName(transition, uri);
            String execJob = this.executeJob(item, postData, types, actPath, transition, agent);
            if (types.contains("application/xml") || types.contains("text/xml")) {
                return execJob;
            }
            return XML.toJSONObject((String)execJob, (boolean)true).toString();
        }
        catch (InvalidCollectionModification | InvalidDataException | ObjectAlreadyExistsException | OutcomeBuilderException | ScriptErrorException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), (Exception)e, Response.Status.BAD_REQUEST);
        }
        catch (AccessRightsException e) {
            throw ItemUtils.createWebAppException(e.getMessage(), (Exception)((Object)e), Response.Status.UNAUTHORIZED);
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), (Exception)((Object)e), Response.Status.NOT_FOUND);
        }
        catch (InvalidTransitionException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), (Exception)((Object)e), Response.Status.CONFLICT);
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), (Exception)((Object)e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"multipart/form-data"})
    @javax.ws.rs.Path(value="{binaryUploadPath: .*}")
    public String requestBinaryTransition(String postData, @FormDataParam(value="file") InputStream file, @Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @PathParam(value="binaryUploadPath") String actPath, @QueryParam(value="transition") String transition, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        AgentProxy agent = null;
        try {
            agent = (AgentProxy)Gateway.getProxyManager().getProxy((Path)this.checkAuthCookie(authCookie));
        }
        catch (ObjectNotFoundException e1) {
            throw ItemUtils.createWebAppException(e1.getMessage(), Response.Status.UNAUTHORIZED);
        }
        if (actPath == null) {
            throw ItemUtils.createWebAppException("Must specify activity path", Response.Status.BAD_REQUEST);
        }
        if (file == null) {
            throw ItemUtils.createWebAppException("Must provide a file to upload", Response.Status.BAD_REQUEST);
        }
        ItemProxy item = ItemRoot.getProxy(uuid);
        try {
            List types = headers.getRequestHeader("Content-Type");
            Logger.msg((int)5, (String)"ItemRoot.requestTransition() postData:%s", (Object[])new Object[]{postData});
            if (actPath.startsWith("workflow/predefined/")) {
                return this.executePredefinedStep(item, postData, types, actPath, agent);
            }
            transition = this.extractAndCcheckTransitionName(transition, uri);
            return this.executeUploadJob(item, file, postData, types, actPath, transition, agent);
        }
        catch (InvalidCollectionModification | InvalidDataException | ObjectAlreadyExistsException | OutcomeBuilderException | ScriptErrorException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), (Exception)e, Response.Status.BAD_REQUEST);
        }
        catch (AccessRightsException e) {
            throw ItemUtils.createWebAppException(e.getMessage(), (Exception)((Object)e), Response.Status.UNAUTHORIZED);
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), (Exception)((Object)e), Response.Status.NOT_FOUND);
        }
        catch (InvalidTransitionException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), (Exception)((Object)e), Response.Status.CONFLICT);
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), (Exception)((Object)e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String executeUploadJob(ItemProxy item, InputStream file, String postData, List<String> types, String actPath, String transition, AgentProxy agent) throws AccessRightsException, ObjectNotFoundException, PersistencyException, InvalidDataException, OutcomeBuilderException, InvalidTransitionException, ObjectAlreadyExistsException, InvalidCollectionModification, ScriptErrorException, IOException {
        Job thisJob = item.getJobByTransitionName(actPath, transition, agent);
        byte[] binaryData = IOUtils.toByteArray((InputStream)file);
        if (thisJob == null) {
            throw ItemUtils.createWebAppException("Job not found for actPath:" + actPath + " transition:" + transition, Response.Status.NOT_FOUND);
        }
        if (thisJob.hasOutcome()) {
            OutcomeAttachment outcomeAttachment = new OutcomeAttachment(item.getPath(), thisJob.getSchema().getName(), thisJob.getSchema().getVersion().intValue(), -1, "application/octet-stream", binaryData);
            thisJob.setAttachment(outcomeAttachment);
        }
        return agent.execute(thisJob);
    }

    @GET
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="job/formTemplate/{activityPath: .*}")
    public Response getJobFormTemplate(@Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @PathParam(value="activityPath") String actPath, @QueryParam(value="transition") String transition, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        AgentProxy agent = null;
        try {
            agent = (AgentProxy)Gateway.getProxyManager().getProxy((Path)this.checkAuthCookie(authCookie));
        }
        catch (ObjectNotFoundException e1) {
            throw ItemUtils.createWebAppException(e1.getMessage(), Response.Status.UNAUTHORIZED);
        }
        if (actPath == null) {
            throw ItemUtils.createWebAppException("Must specify activity path", Response.Status.BAD_REQUEST);
        }
        ItemProxy item = ItemRoot.getProxy(uuid);
        try {
            if (actPath.startsWith("workflow/predefined/")) {
                throw ItemUtils.createWebAppException("Unimplemented", Response.Status.BAD_REQUEST);
            }
            Job thisJob = item.getJobByTransitionName(actPath, transition = this.extractAndCcheckTransitionName(transition, uri), agent);
            if (thisJob == null) {
                throw ItemUtils.createWebAppException("Job not found for actPath:" + actPath + " transition:" + transition, Response.Status.NOT_FOUND);
            }
            CastorHashMap inputs = (CastorHashMap)thisJob.getActProps().clone();
            inputs.put((Object)"agent", (Object)agent);
            inputs.put((Object)"item", (Object)item);
            inputs.put((Object)"job", (Object)thisJob);
            if (thisJob.hasOutcome()) {
                return Response.ok((Object)new OutcomeBuilder(thisJob.getSchema(), false).generateNgDynamicForms((Map)inputs)).build();
            }
            Logger.msg((int)5, (String)"ItemRoot.getJobFormTemplate() - no outcome needed for job:%s", (Object[])new Object[]{thisJob});
            return Response.noContent().build();
        }
        catch (InvalidDataException | OutcomeBuilderException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), (Exception)e, Response.Status.BAD_REQUEST);
        }
        catch (AccessRightsException e) {
            throw ItemUtils.createWebAppException(e.getMessage(), (Exception)((Object)e), Response.Status.UNAUTHORIZED);
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), (Exception)((Object)e), Response.Status.NOT_FOUND);
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), (Exception)((Object)e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String extractAndCcheckTransitionName(String transName, UriInfo uri) {
        if (StringUtils.isNotBlank((CharSequence)transName)) {
            return transName;
        }
        for (String key : uri.getQueryParameters().keySet()) {
            List qparams = (List)uri.getQueryParameters().get((Object)key);
            if (qparams.size() != 1 || ((String)qparams.get(0)).length() != 0) continue;
            return key;
        }
        throw ItemUtils.createWebAppException("Must specify transition name", Response.Status.BAD_REQUEST);
    }
}

