/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.collection.AggregationMember;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionDescription;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.GTimeStamp;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.persistency.outcomebuilder.OutcomeBuilder;
import org.cristalise.kernel.persistency.outcomebuilder.OutcomeBuilderException;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.scripting.ScriptErrorException;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.DateUtility;
import org.cristalise.kernel.utils.KeyValuePair;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.restapi.ItemRoot;
import org.cristalise.restapi.RemoteMapAccess;
import org.cristalise.restapi.RestHandler;
import org.json.JSONObject;
import org.json.XML;

public abstract class ItemUtils
extends RestHandler {
    protected static final String PREDEFINED_PATH = "workflow/predefined/";
    private static int defaultLogLevel;
    final DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ItemUtils() {
        defaultLogLevel = Gateway.getProperties().getInt("LOGGER.defaultLevel", 9);
    }

    protected static URI getItemURI(UriInfo uri, ItemProxy item, Object ... path) {
        return ItemUtils.getItemURI(uri, item.getPath(), path);
    }

    protected static URI getItemURI(UriInfo uri, ItemPath item, Object ... path) {
        return ItemUtils.getItemURI(uri, item.getUUID(), path);
    }

    protected static URI getItemURI(UriInfo uri, UUID item, Object ... path) {
        UriBuilder builder = uri.getBaseUriBuilder().path("item").path(item.toString());
        for (Object name : path) {
            builder.path(name.toString());
        }
        return builder.build(new Object[0]);
    }

    protected static URI getItemURI(UriInfo uri, Object ... segments) {
        UriBuilder builder = uri.getBaseUriBuilder().path("item");
        for (Object path : segments) {
            builder.path(path.toString());
        }
        return builder.build(new Object[0]);
    }

    protected static ArrayList<LinkedHashMap<String, String>> getPropertySummary(ItemProxy item) throws ObjectNotFoundException {
        ArrayList<LinkedHashMap<String, String>> props = new ArrayList<LinkedHashMap<String, String>>();
        for (String propName : item.getContents(ClusterType.PROPERTY)) {
            LinkedHashMap<String, String> prop = new LinkedHashMap<String, String>();
            prop.put("name", propName);
            prop.put("value", item.getProperty(propName));
            props.add(prop);
        }
        return props;
    }

    protected static ItemProxy getProxy(String uuid) {
        ItemProxy item;
        ItemPath itemPath;
        try {
            itemPath = Gateway.getLookup().getItemPath(uuid);
        }
        catch (InvalidItemPathException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.NOT_FOUND);
        }
        try {
            item = Gateway.getProxyManager().getProxy((Path)itemPath);
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.NOT_FOUND);
        }
        return item;
    }

    public Response getViewpointOutcome(String uuid, String schema, String viewName, boolean json) {
        ItemProxy item = ItemRoot.getProxy(uuid);
        try {
            Viewpoint view = item.getViewpoint(schema, viewName);
            return this.getOutcomeResponse(view.getOutcome(), json);
        }
        catch (ObjectNotFoundException | PersistencyException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), (Exception)e, Response.Status.NOT_FOUND);
        }
    }

    public Response getOutcome(String uuid, String schema, int version, int eventId, boolean json) {
        ItemProxy item = ItemRoot.getProxy(uuid);
        try {
            Outcome outcome = item.getOutcome(schema, version, eventId);
            return this.getOutcomeResponse(outcome, (Event)RemoteMapAccess.get(item, ClusterType.HISTORY, Integer.toString(eventId)), json);
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.NOT_FOUND);
        }
    }

    public ArrayList<LinkedHashMap<String, Object>> enumerate(ItemProxy item, ClusterType cluster, String uriPath, UriInfo uri) {
        return this.enumerate(item, cluster.getName(), uriPath, uri);
    }

    public ArrayList<LinkedHashMap<String, Object>> enumerate(ItemProxy item, String dataPath, String uriPath, UriInfo uri) {
        try {
            String[] children = item.getContents(dataPath);
            ArrayList<LinkedHashMap<String, Object>> childrenData = new ArrayList<LinkedHashMap<String, Object>>();
            for (String childName : children) {
                LinkedHashMap<String, Object> childData = new LinkedHashMap<String, Object>();
                childData.put("name", childName);
                childData.put("url", ItemUtils.getItemURI(uri, item, new Object[]{uriPath, childName}));
                childrenData.add(childData);
            }
            return childrenData;
        }
        catch (ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Database Error");
        }
    }

    protected ArrayList<LinkedHashMap<String, Object>> getAllViewpoints(ItemProxy item, UriInfo uri) {
        ArrayList<LinkedHashMap<String, Object>> viewPoints = this.enumerate(item, ClusterType.VIEWPOINT, "viewpoint", uri);
        for (LinkedHashMap<String, Object> vp : viewPoints) {
            String schema = vp.get("name").toString();
            vp.put("views", this.enumerate(item, ClusterType.VIEWPOINT + "/" + schema, "viewpoint/" + schema, uri));
        }
        return viewPoints;
    }

    protected Response getOutcomeResponse(Outcome oc, boolean json) {
        String result = json ? XML.toJSONObject((String)oc.getData()).toString() : oc.getData();
        return Response.ok((Object)result).build();
    }

    protected Response getOutcomeResponse(Outcome oc, Date eventDate, boolean json) {
        String result = json ? XML.toJSONObject((String)oc.getData()).toString() : oc.getData();
        return Response.ok((Object)result).lastModified(eventDate).build();
    }

    protected Response getOutcomeResponse(Outcome oc, Event ev, boolean json) {
        try {
            Date eventDate = this.dateFormatter.parse(ev.getTimeString());
            return this.getOutcomeResponse(oc, eventDate, json);
        }
        catch (ParseException e) {
            Logger.error((Throwable)e);
            throw ItemUtils.createWebAppException("Invalid timestamp in event " + ev.getID() + ": " + ev.getTimeString());
        }
    }

    protected LinkedHashMap<String, Object> makeEventData(Event ev, UriInfo uri) {
        LinkedHashMap<String, Object> eventData = new LinkedHashMap<String, Object>();
        eventData.put("id", ev.getID());
        eventData.put("timestamp", DateUtility.timeStampToUtcString((GTimeStamp)ev.getTimeStamp()));
        eventData.put("agent", ev.getAgentPath().getAgentName());
        eventData.put("role", ev.getAgentRole());
        if (ev.getSchemaName() != null && ev.getSchemaName().length() > 0) {
            LinkedHashMap<String, Object> outcomeData = new LinkedHashMap<String, Object>();
            outcomeData.put("name", ev.getViewName());
            outcomeData.put("schema", ev.getSchemaName());
            outcomeData.put("schemaVersion", ev.getSchemaVersion());
            outcomeData.put("data", ItemUtils.getItemURI(uri, ev.getItemUUID(), "outcome", ev.getSchemaName(), ev.getSchemaVersion(), ev.getID()));
            eventData.put("outcome", outcomeData);
        }
        LinkedHashMap<String, String> activityData = new LinkedHashMap<String, String>();
        activityData.put("name", ev.getStepName());
        activityData.put("path", ev.getStepPath());
        activityData.put("type", ev.getStepType());
        eventData.put("activity", activityData);
        LinkedHashMap<String, Object> transData = new LinkedHashMap<String, Object>();
        try {
            StateMachine sm = LocalObjectLoader.getStateMachine((String)ev.getStateMachineName(), (int)ev.getStateMachineVersion());
            transData.put("name", sm.getTransition(ev.getTransition()).getName());
            transData.put("origin", sm.getState(ev.getOriginState()).getName());
            transData.put("target", sm.getState(ev.getTargetState()).getName());
            transData.put("stateMachine", ev.getStateMachineName());
            transData.put("stateMachineVersion", ev.getStateMachineVersion());
            eventData.put("transition", transData);
        }
        catch (ObjectNotFoundException e) {
            eventData.put("transition", "ERROR: State Machine " + ev.getStateMachineName() + " v" + ev.getStateMachineVersion() + " not found!");
        }
        catch (InvalidDataException e) {
            eventData.put("transition", "ERROR: State Machine definition " + ev.getStateMachineName() + " v" + ev.getStateMachineVersion() + " not valid!");
        }
        return eventData;
    }

    protected LinkedHashMap<String, Object> makeJobData(Job job, String itemName, UriInfo uri) {
        String attachmentType;
        LinkedHashMap<String, Object> jobData = new LinkedHashMap<String, Object>();
        String agentName = job.getAgentName();
        if (StringUtils.isNotBlank((CharSequence)agentName)) {
            jobData.put("agent", agentName);
        }
        jobData.put("role", job.getAgentRole());
        jobData.put("item", this.getJobItemData(job, itemName, uri));
        jobData.put("activity", this.getJobActivityData(job, itemName, uri));
        jobData.put("transition", this.getJobTransitionData(job, itemName, uri));
        if (job.hasOutcome()) {
            jobData.put("outcome", this.getJobOutcomeData(job, itemName, uri));
        }
        if (StringUtils.isNotBlank((CharSequence)(attachmentType = job.getActPropString(BuiltInVertexProperties.ATTACHMENT_MIME_TYPES)))) {
            jobData.put("attachmentMimeTypes", attachmentType);
        }
        return jobData;
    }

    protected LinkedHashMap<String, Object> getJobItemData(Job job, String itemName, UriInfo uri) {
        LinkedHashMap<String, Object> itemData = new LinkedHashMap<String, Object>();
        itemData.put("uuid", job.getItemUUID());
        itemData.put("name", itemName);
        try {
            String type = job.getItem().getType();
            if (StringUtils.isNotBlank((CharSequence)type)) {
                itemData.put("type", type);
            }
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        itemData.put("url", ItemUtils.getItemURI(uri, job.getItemUUID()));
        return itemData;
    }

    protected LinkedHashMap<String, Object> getJobActivityData(Job job, String itemName, UriInfo uri) {
        LinkedHashMap<String, Object> activityData = new LinkedHashMap<String, Object>();
        activityData.put("name", job.getStepName());
        activityData.put("path", job.getStepPath());
        activityData.put("type", job.getStepType());
        LinkedHashMap<String, String> activityPropData = new LinkedHashMap<String, String>();
        for (KeyValuePair actProp : job.getKeyValuePairs()) {
            String key = actProp.getKey();
            String value = job.getActPropString(key);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            activityPropData.put(key, value);
        }
        activityData.put("properties", activityPropData);
        return activityData;
    }

    protected LinkedHashMap<String, Object> getJobTransitionData(Job job, String itemName, UriInfo uri) {
        LinkedHashMap<String, Object> transitionData = new LinkedHashMap<String, Object>();
        URI url = uri.getBaseUriBuilder().path("stateMachine").path(job.getActPropString("StateMachineName")).path(job.getActPropString("StateMachineVersion")).build(new Object[0]);
        transitionData.put("name", job.getTransition().getName());
        transitionData.put("id", job.getTransition().getId());
        transitionData.put("origin", job.getOriginStateName());
        transitionData.put("target", job.getTargetStateName());
        transitionData.put("stateMachine", job.getActPropString("StateMachineName"));
        transitionData.put("stateMachineVersion", job.getActPropString("StateMachineVersion"));
        transitionData.put("stateMachineUrl", url);
        return transitionData;
    }

    protected LinkedHashMap<String, Object> getJobOutcomeData(Job job, String itemName, UriInfo uri) {
        LinkedHashMap<String, Object> outcomeData = new LinkedHashMap<String, Object>();
        try {
            outcomeData.put("required", job.isOutcomeRequired());
            outcomeData.put("schema", job.getSchema().getName());
            outcomeData.put("schemaVersion", job.getSchema().getVersion());
            outcomeData.put("schemaUrl", uri.getBaseUriBuilder().path("schema").path(job.getSchema().getName()).path(String.valueOf(job.getSchema().getVersion())).build(new Object[0]));
        }
        catch (InvalidDataException | ObjectNotFoundException e) {
            Logger.error((Throwable)e);
            outcomeData.put("schema", "Schema not found");
        }
        return outcomeData;
    }

    protected String getItemName(ItemPath ip) {
        Lookup.PagedResult result = Gateway.getLookup().searchAliases(ip, 0, 50);
        if (result.rows.size() > 0) {
            return ((DomainPath)result.rows.get(0)).getName();
        }
        return "";
    }

    protected LinkedHashMap<String, Object> makeCollectionData(Collection<?> coll, UriInfo uri) {
        LinkedHashMap<String, Object> collData = new LinkedHashMap<String, Object>();
        collData.put("name", coll.getName());
        collData.put("version", coll.getVersionName());
        String collType = "Collection";
        if (coll instanceof Aggregation) {
            collType = "Aggregation";
        } else if (coll instanceof Dependency) {
            collType = "Dependency";
        }
        collData.put("type", collType);
        collData.put("isDescription", coll instanceof CollectionDescription);
        if (coll instanceof Dependency) {
            Dependency dep = (Dependency)coll;
            this.addCollectionProps(collData, dep.getProperties(), dep.getClassProps(), true);
        }
        ArrayList<LinkedHashMap<String, Object>> members = new ArrayList<LinkedHashMap<String, Object>>();
        for (CollectionMember member : coll.getMembers().list) {
            LinkedHashMap<String, Object> thisMemberData = new LinkedHashMap<String, Object>();
            thisMemberData.put("id", member.getID());
            if (member.getItemPath() != null) {
                thisMemberData.put("name", this.getItemName(member.getItemPath()));
                thisMemberData.put("uuid", member.getItemPath().getUUID());
                thisMemberData.put("url", ItemUtils.getItemURI(uri, member.getItemPath(), new Object[0]));
            }
            this.addCollectionProps(thisMemberData, member.getProperties(), member.getClassProps(), coll instanceof Aggregation);
            if (member instanceof AggregationMember) {
                thisMemberData.put("geometry", this.makeGeoData((AggregationMember)member));
            }
            members.add(thisMemberData);
        }
        collData.put("members", members);
        return collData;
    }

    private LinkedHashMap<String, Integer> makeGeoData(AggregationMember aggMem) {
        LinkedHashMap<String, Integer> geo = new LinkedHashMap<String, Integer>();
        geo.put("x", aggMem.getCentrePoint().x);
        geo.put("y", aggMem.getCentrePoint().y);
        geo.put("width", aggMem.getWidth());
        geo.put("heigth", aggMem.getHeight());
        return geo;
    }

    private void addCollectionProps(LinkedHashMap<String, Object> collData, CastorHashMap props, String classProps, boolean includeClassProps) {
        List<String> classPropList = null;
        if (classProps != null) {
            classPropList = Arrays.asList(classProps.split(","));
        }
        ArrayList classPropData = new ArrayList();
        ArrayList propData = new ArrayList();
        for (KeyValuePair prop : props.getKeyValuePairs()) {
            LinkedHashMap<String, Object> propMap = new LinkedHashMap<String, Object>();
            propMap.put("name", prop.getKey());
            propMap.put("value", prop.getValue());
            if (classPropList != null && classPropList.contains(prop.getKey())) {
                classPropData.add(propMap);
                continue;
            }
            propData.add(propMap);
        }
        if (classPropData.size() > 0 && includeClassProps) {
            collData.put("classIdentifiers", classPropData);
        }
        if (propData.size() > 0) {
            collData.put("properties", propData);
        }
    }

    public static WebApplicationException createWebAppException(String msg) {
        return ItemUtils.createWebAppException(msg, Response.Status.INTERNAL_SERVER_ERROR);
    }

    public static WebApplicationException createWebAppException(String msg, Response.Status status) {
        return ItemUtils.createWebAppException(msg, null, status);
    }

    public static WebApplicationException createWebAppException(String msg, Exception ex, Response.Status status) {
        Logger.debug((int)8, (String)("ItemUtils.createWebAppException() - msg:" + msg + " status:" + status), (Object[])new Object[0]);
        if (ex != null && Logger.doLog((int)defaultLogLevel)) {
            Logger.error((Throwable)ex);
        }
        if (Gateway.getProperties().getBoolean("REST.Debug.errorsWithBody", false)) {
            StringBuffer sb = new StringBuffer("[errorMessage]");
            sb.append(msg).append("[/errorMessage]");
            if (ex != null) {
                sb.append(" - Exception:" + ex.getMessage());
            }
            return new WebApplicationException(sb.toString(), Response.status((Response.Status)status).entity((Object)msg).build());
        }
        return new WebApplicationException(msg, status);
    }

    public static boolean produceJSON(List<MediaType> types) {
        if (types.isEmpty()) {
            return false;
        }
        for (MediaType t : types) {
            if (t.isCompatible(MediaType.APPLICATION_XML_TYPE) || t.isCompatible(MediaType.TEXT_XML_TYPE)) {
                return false;
            }
            if (!t.isCompatible(MediaType.APPLICATION_JSON_TYPE)) continue;
            return true;
        }
        throw ItemUtils.createWebAppException("Supported media types: TEXT_XML, APPLICATION_XML, APPLICATION_JSON", Response.Status.UNSUPPORTED_MEDIA_TYPE);
    }

    public static List<String> getItemNames(Property ... props) {
        Lookup.PagedResult result = Gateway.getLookup().search((Path)new DomainPath(""), Arrays.asList(props), 0, 1000);
        ArrayList<String> names = new ArrayList<String>();
        for (Path path : result.rows) {
            names.add(path.getName());
        }
        Collections.sort(names);
        return names;
    }

    protected String executePredefinedStep(ItemProxy item, String postData, List<String> types, String actPath, AgentProxy agent) throws ObjectNotFoundException, InvalidDataException, OutcomeBuilderException, AccessRightsException, InvalidTransitionException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification {
        if (!actPath.startsWith(PREDEFINED_PATH)) {
            throw new InvalidDataException("Predefined Step path should start with workflow/predefined/");
        }
        if (types.contains("application/json")) {
            OutcomeBuilder builder = new OutcomeBuilder(LocalObjectLoader.getSchema((String)"PredefinesStepOutcome", (int)0));
            builder.addJsonInstance(new JSONObject(postData));
            postData = builder.getOutcome(false).getData();
        }
        return agent.execute(item, actPath.substring(PREDEFINED_PATH.length()), postData);
    }

    protected String executeJob(ItemProxy item, String postData, List<String> types, String actPath, String transition, AgentProxy agent) throws AccessRightsException, ObjectNotFoundException, PersistencyException, InvalidDataException, OutcomeBuilderException, InvalidTransitionException, ObjectAlreadyExistsException, InvalidCollectionModification, ScriptErrorException {
        Job thisJob = item.getJobByTransitionName(actPath, transition, agent);
        if (thisJob == null) {
            throw ItemUtils.createWebAppException("Job not found for actPath:" + actPath + " transition:" + transition, Response.Status.NOT_FOUND);
        }
        if (thisJob.hasOutcome()) {
            if (types.contains("application/xml") || types.contains("text/xml")) {
                thisJob.setOutcome(postData);
            } else {
                OutcomeBuilder builder = new OutcomeBuilder(thisJob.getSchema());
                builder.addJsonInstance(new JSONObject(postData));
                thisJob.setOutcome(builder.getOutcome(false));
            }
        }
        return agent.execute(thisJob);
    }
}

