/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.PathUtils;

@javax.ws.rs.Path(value="/role")
public class RoleAccess
extends PathUtils {
    @GET
    @Produces(value={"application/json"})
    public Response listRoles(@CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        return this.listRoles("", authCookie, uri);
    }

    @GET
    @javax.ws.rs.Path(value="{path: .*}")
    @Produces(value={"application/json"})
    public Response listRoles(@PathParam(value="path") String path, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        this.checkAuthCookie(authCookie);
        ArrayList<Map<String, Object>> childRolesData = new ArrayList<Map<String, Object>>();
        RolePath startRole = new RolePath(path);
        Iterator children = Gateway.getLookup().getChildren((Path)startRole);
        while (children.hasNext()) {
            childRolesData.add(this.makeLookupData(path, (Path)children.next(), uri));
        }
        childRolesData.addAll(this.getRoleAgentsData(path, startRole, uri));
        return this.toJSON(childRolesData);
    }

    @GET
    @javax.ws.rs.Path(value="{role}/summary")
    @Produces(value={"application/json"})
    public Response getRoleSummary(@PathParam(value="role") String roleName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        AgentPath[] agents;
        RolePath role;
        this.checkAuthCookie(authCookie);
        try {
            role = Gateway.getLookup().getRolePath(roleName);
        }
        catch (ObjectNotFoundException e1) {
            throw ItemUtils.createWebAppException(e1.getMessage(), Response.Status.NOT_FOUND);
        }
        LinkedHashMap<String, Object> roleData = new LinkedHashMap<String, Object>();
        roleData.put("name", roleName);
        roleData.put("hasJobList", role.hasJobList());
        Iterator childRoles = Gateway.getLookup().getChildren((Path)role);
        if (childRoles.hasNext()) {
            LinkedHashMap<String, URI> childRoleData = new LinkedHashMap<String, URI>();
            while (childRoles.hasNext()) {
                RolePath childRole = (RolePath)childRoles.next();
                childRoleData.put(childRole.getName(), uri.getBaseUriBuilder().path("role").path(childRole.getName()).build(new Object[0]));
            }
            roleData.put("subroles", childRoleData);
        }
        try {
            agents = Gateway.getLookup().getAgents(role);
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.NOT_FOUND);
        }
        if (agents.length > 0) {
            LinkedHashMap<String, URI> agentData = new LinkedHashMap<String, URI>();
            for (AgentPath agent : agents) {
                agentData.put(agent.getAgentName(), uri.getBaseUriBuilder().path("item").path(agent.getUUID().toString()).build(new Object[0]));
            }
            roleData.put("agents", agentData);
        }
        return this.toJSON(roleData);
    }

    protected List<Map<String, Object>> getRoleAgentsData(String path, RolePath role, UriInfo uri) {
        ArrayList<Map<String, Object>> agentsData = new ArrayList<Map<String, Object>>();
        try {
            AgentPath[] agents;
            for (AgentPath agent : agents = Gateway.getLookup().getAgents(role)) {
                agentsData.add(this.makeLookupData(path, (Path)agent, uri));
            }
            return agentsData;
        }
        catch (ObjectNotFoundException e) {
            throw ItemUtils.createWebAppException(e.getMessage(), Response.Status.NOT_FOUND);
        }
    }
}

