/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.net.URLDecoder;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.restapi.ItemUtils;
import org.json.JSONObject;
import org.json.XML;

public class ScriptUtils
extends ItemUtils {
    static Semaphore mutex = new Semaphore(1);

    protected Object executeScript(ItemProxy item, Script script, CastorHashMap inputs) throws ScriptingEngineException, InvalidDataException {
        Object scriptResult = null;
        try {
            scriptResult = script.evaluate(item == null ? script.getItemPath() : item.getPath(), inputs, null, null);
        }
        catch (ScriptingEngineException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidDataException(e.getMessage());
        }
        return scriptResult;
    }

    public Response executeScript(HttpHeaders headers, ItemProxy item, String scriptName, Integer scriptVersion, String inputJson, Map<String, Object> additionalInputs) {
        if (scriptVersion == null) {
            scriptVersion = 0;
        }
        Script script = null;
        if (scriptName != null) {
            try {
                script = LocalObjectLoader.getScript((String)scriptName, (int)scriptVersion);
                JSONObject json = new JSONObject(inputJson == null ? "{}" : URLDecoder.decode(inputJson, "UTF-8"));
                CastorHashMap inputs = new CastorHashMap();
                for (String key : json.keySet()) {
                    inputs.put((Object)key, json.get(key));
                }
                inputs.putAll(additionalInputs);
                return this.returnScriptResult(scriptName, item, null, script, inputs, ScriptUtils.produceJSON(headers.getAcceptableMediaTypes()));
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
                if (e.getMessage().contains("[errorMessage]")) {
                    throw ItemUtils.createWebAppException(e.getMessage(), e, Response.Status.NOT_FOUND);
                }
                throw ItemUtils.createWebAppException("Error executing script, please contact support", e, Response.Status.NOT_FOUND);
            }
        }
        throw ItemUtils.createWebAppException("Name or UUID of Script was missing", Response.Status.NOT_FOUND);
    }

    public Response returnScriptResult(String scriptName, ItemProxy item, Schema schema, Script script, CastorHashMap inputs, boolean jsonFlag) throws ScriptingEngineException, InvalidDataException {
        try {
            mutex.acquire();
            Response response = this.runScript(scriptName, item, schema, script, inputs, jsonFlag);
            return response;
        }
        catch (ScriptingEngineException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidDataException(e.getMessage());
        }
        finally {
            mutex.release();
        }
    }

    protected Response runScript(String scriptName, ItemProxy item, Schema schema, Script script, CastorHashMap inputs, boolean jsonFlag) throws ScriptingEngineException, InvalidDataException {
        String xmlOutcome = null;
        Object scriptResult = this.executeScript(item, script, inputs);
        if (scriptResult instanceof String) {
            xmlOutcome = (String)scriptResult;
        } else if (scriptResult instanceof Map) {
            String key = ((Map)scriptResult).keySet().toArray(new String[0])[0];
            xmlOutcome = (String)((Map)scriptResult).get(key);
        } else {
            throw ItemUtils.createWebAppException("Cannot handle result of script:" + scriptName, Response.Status.NOT_FOUND);
        }
        if (xmlOutcome == null) {
            throw ItemUtils.createWebAppException("Cannot handle result of script:" + scriptName, Response.Status.NOT_FOUND);
        }
        if (schema != null) {
            return this.getOutcomeResponse(new Outcome(xmlOutcome, schema), new Date(), jsonFlag);
        }
        if (jsonFlag) {
            return Response.ok((Object)XML.toJSONObject((String)xmlOutcome, (boolean)true).toString()).build();
        }
        return Response.ok((Object)xmlOutcome).build();
    }
}

