/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.RemoteMapAccess;
import org.cristalise.restapi.WebAppExceptionBuilder;

@Path(value="/agent/{uuid}")
public class AgentJobList
extends ItemUtils {
    @GET
    @Path(value="job")
    @Produces(value={"application/json"})
    public Response listJobs(@PathParam(value="uuid") String uuid, @DefaultValue(value="0") @QueryParam(value="start") Integer start, @QueryParam(value="batch") Integer batchSize, @QueryParam(value="descending") Boolean descending, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        LinkedHashMap<String, Object> batch;
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        descending = descending != null;
        if (!(item instanceof AgentProxy)) {
            throw new WebAppExceptionBuilder().message("UUID does not belong to an Agent").status(Response.Status.BAD_REQUEST).newCookie(cookie).build();
        }
        if (batchSize == null) {
            batchSize = Gateway.getProperties().getInt("REST.Job.DefaultBatchSize", Gateway.getProperties().getInt("REST.DefaultBatchSize", 20));
        }
        try {
            batch = RemoteMapAccess.list(item, ClusterType.JOB, start, batchSize, descending, uri);
        }
        catch (ClassCastException | ObjectNotFoundException e) {
            throw new WebAppExceptionBuilder().exception((Exception)e).newCookie(cookie).build();
        }
        ArrayList<LinkedHashMap<String, Object>> jobs = new ArrayList<LinkedHashMap<String, Object>>();
        for (String key : batch.keySet()) {
            Object obj = batch.get(key);
            if (!(obj instanceof Job)) continue;
            Job job = (Job)obj;
            try {
                jobs.add(this.makeJobData(job, job.getItemProxy().getName(), uri));
            }
            catch (ObjectNotFoundException | InvalidItemPathException e) {
                throw new WebAppExceptionBuilder().message("Item " + job.getItemUUID() + " in Job not found").status(Response.Status.NOT_FOUND).newCookie(cookie).build();
            }
        }
        return this.toJSON(jobs, cookie).build();
    }

    @GET
    @Path(value="job/{jobId}")
    @Produces(value={"application/json"})
    public Response getJob(@PathParam(value="uuid") String uuid, @PathParam(value="jobId") String jobId, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        if (!(item instanceof AgentProxy)) {
            throw new WebAppExceptionBuilder().message("UUID does not belong to an Agent").status(Response.Status.BAD_REQUEST).newCookie(cookie).build();
        }
        try {
            Job job = (Job)RemoteMapAccess.get(item, ClusterType.JOB, jobId);
            return this.toJSON(this.makeJobData(job, item.getName(), uri), cookie).build();
        }
        catch (ClassCastException | ObjectNotFoundException e) {
            throw new WebAppExceptionBuilder().exception((Exception)e).newCookie(cookie).build();
        }
    }

    @GET
    @Path(value="roles")
    @Produces(value={"application/json"})
    public Response getRoles(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        if (!(item instanceof AgentProxy)) {
            throw new WebAppExceptionBuilder().message("UUID does not belong to an Agent").status(Response.Status.BAD_REQUEST).newCookie(cookie).build();
        }
        AgentProxy agent = (AgentProxy)item;
        RolePath[] roles = Gateway.getLookup().getRoles(agent.getPath());
        LinkedHashMap<String, URI> roleData = new LinkedHashMap<String, URI>();
        for (RolePath role : roles) {
            roleData.put(role.getName(), uri.getBaseUriBuilder().path("role").path(role.getName()).build(new Object[0]));
        }
        return this.toJSON(roleData, cookie).build();
    }
}

