/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.PathUtils;
import org.cristalise.restapi.WebAppExceptionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@javax.ws.rs.Path(value="/domain")
public class PathAccess
extends PathUtils {
    private static final Logger log = LoggerFactory.getLogger(PathAccess.class);

    @GET
    @Produces(value={"application/json"})
    public Response queryPath(@DefaultValue(value="0") @QueryParam(value="start") Integer start, @QueryParam(value="batch") Integer batchSize, @QueryParam(value="search") String search, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        return this.queryPath("/", start, batchSize, search, authCookie, uri);
    }

    @GET
    @javax.ws.rs.Path(value="{path: .*}")
    @Produces(value={"application/json"})
    public Response queryPath(@PathParam(value="path") String path, @DefaultValue(value="0") @QueryParam(value="start") Integer start, @QueryParam(value="batch") Integer batchSize, @QueryParam(value="search") String search, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        DomainPath domPath = new DomainPath(path);
        if (batchSize == null) {
            batchSize = Gateway.getProperties().getInt("REST.Path.DefaultBatchSize", Gateway.getProperties().getInt("REST.DefaultBatchSize", 75));
        }
        if (path.equals("aliases") && search != null && search.startsWith("[") && search.endsWith("]")) {
            return this.getAliases(search, cookie).build();
        }
        if (!domPath.exists()) {
            throw new WebAppExceptionBuilder().message("Domain path does not exist").status(Response.Status.NOT_FOUND).newCookie(cookie).build();
        }
        try {
            ItemPath item = domPath.getItemPath();
            return Response.seeOther((URI)ItemUtils.getItemURI(uri, item, new Object[0])).build();
        }
        catch (ObjectNotFoundException item) {
            Lookup.PagedResult childSearch = search == null ? Gateway.getLookup().getChildren((Path)domPath, start.intValue(), batchSize.intValue()) : Gateway.getLookup().search((Path)domPath, this.getPropertiesFromQParams(search), start.intValue(), batchSize.intValue());
            ArrayList<Map<String, Object>> pathDataArray = new ArrayList<Map<String, Object>>();
            for (Path p : childSearch.rows) {
                pathDataArray.add(this.makeLookupData(path, p, uri));
            }
            return this.toJSON(this.getPagedResult(uri, start, batchSize, childSearch.maxRows, pathDataArray), cookie).build();
        }
    }

    private Response.ResponseBuilder getAliases(String uuids, NewCookie cookie) {
        log.info("getAliases() - uuids:{}", (Object)uuids);
        JSONArray uuidsArray = new JSONArray(uuids);
        ArrayList<Map<String, Object>> returnVal = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < uuidsArray.length(); ++i) {
            String uuid = uuidsArray.getString(i);
            try {
                Map<String, Object> itemAliases = this.makeItemDomainPathsData(Gateway.getLookup().getItemPath(uuid));
                returnVal.add(itemAliases);
                continue;
            }
            catch (JSONException | ObjectNotFoundException | InvalidItemPathException e) {
                LinkedHashMap<String, String> error = new LinkedHashMap<String, String>();
                error.put("uuid", uuid);
                error.put("error", e.getMessage());
                returnVal.add(error);
            }
        }
        return this.toJSON(returnVal, cookie);
    }
}

