/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.OutcomeAttachment;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.WebAppExceptionBuilder;

@Path(value="/item/{uuid}/attachment")
public class ItemOutcomeAttachment
extends ItemUtils {
    @GET
    @Produces(value={"application/json"})
    public Response getOutcomeSchemas(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        return this.toJSON(this.enumerate(item, ClusterType.ATTACHMENT, "attachment", uri, cookie), cookie).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}")
    public Response getOutcomeVersions(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        return this.toJSON(this.enumerate(item, ClusterType.ATTACHMENT + "/" + schema, "attachment/" + schema, uri, cookie), cookie).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}/{version}")
    public Response getOutcomeEvents(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="version") Integer version, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        return this.toJSON(this.enumerate(item, ClusterType.ATTACHMENT + "/" + schema + "/" + version, "attachment/" + schema + "/" + version, uri, cookie), cookie).build();
    }

    @GET
    @Produces(value={"application/octet-stream"})
    @Path(value="{schema}/{version}/{event}")
    public Response queryBinaryData(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="version") Integer version, @PathParam(value="event") Integer event, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        try {
            OutcomeAttachment attachemnt = item.getOutcomeAttachment(schema, version.intValue(), event.intValue());
            Response.ResponseBuilder builder = Response.ok((Object)attachemnt.getBinaryData()).type(attachemnt.getType());
            return builder.build();
        }
        catch (ObjectNotFoundException e) {
            throw new WebAppExceptionBuilder().exception((Exception)((Object)e)).newCookie(cookie).build();
        }
    }
}

