/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.RemoteMapAccess;
import org.cristalise.restapi.WebAppExceptionBuilder;

@Path(value="/item/{uuid}/history")
public class ItemHistory
extends ItemUtils {
    @GET
    @Produces(value={"application/json"})
    public Response listEvents(@PathParam(value="uuid") String uuid, @QueryParam(value="start") Integer start, @QueryParam(value="batch") Integer batchSize, @QueryParam(value="descending") Boolean descending, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        LinkedHashMap<String, Object> batch;
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        if (start == null) {
            start = 0;
        }
        descending = descending != null;
        if (batchSize == null) {
            batchSize = Gateway.getProperties().getInt("REST.Event.DefaultBatchSize", Gateway.getProperties().getInt("REST.DefaultBatchSize", 20));
        }
        try {
            batch = RemoteMapAccess.list(item, ClusterType.HISTORY, start, batchSize, descending, uri);
        }
        catch (ClassCastException | ObjectNotFoundException e) {
            throw new WebAppExceptionBuilder().exception((Exception)e).newCookie(cookie).build();
        }
        ArrayList<LinkedHashMap<String, Object>> events = new ArrayList<LinkedHashMap<String, Object>>();
        for (String key : batch.keySet()) {
            Object obj = batch.get(key);
            if (!(obj instanceof Event)) continue;
            events.add(this.makeEventData((Event)obj, uri));
        }
        return this.toJSON(events, cookie).build();
    }

    @GET
    @Path(value="{eventId}")
    @Produces(value={"application/json"})
    public Response getEvent(@PathParam(value="uuid") String uuid, @PathParam(value="eventId") String eventId, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        try {
            Event ev = (Event)RemoteMapAccess.get(item, ClusterType.HISTORY, eventId);
            return this.toJSON(this.makeEventData(ev, uri), cookie).build();
        }
        catch (ObjectNotFoundException e) {
            throw new WebAppExceptionBuilder().exception((Exception)((Object)e)).newCookie(cookie).build();
        }
    }

    private Response.ResponseBuilder getEventOutcome(ItemProxy item, String eventId, UriInfo uri, boolean json, NewCookie cookie) {
        try {
            Event ev = (Event)RemoteMapAccess.get(item, ClusterType.HISTORY, eventId);
            if (ev.getSchemaName() == null || ev.getSchemaName().equals("")) {
                throw new ObjectNotFoundException("This event has no data");
            }
            Outcome oc = (Outcome)item.getObject(ClusterType.OUTCOME + "/" + ev.getSchemaName() + "/" + ev.getSchemaVersion() + "/" + ev.getID());
            return this.getOutcomeResponse(oc, ev, json, cookie);
        }
        catch (ObjectNotFoundException e) {
            throw new WebAppExceptionBuilder().exception((Exception)((Object)e)).newCookie(cookie).build();
        }
    }

    @GET
    @Path(value="{eventId}/data")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getEventOutcome(@Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @PathParam(value="eventId") String eventId, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        return this.getEventOutcome(item, eventId, uri, ItemHistory.produceJSON(headers.getAcceptableMediaTypes()), cookie).build();
    }
}

