/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.io.IOException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.persistency.outcomebuilder.OutcomeBuilderException;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.scripting.ScriptErrorException;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppExceptionBuilder {
    private static final Logger log = LoggerFactory.getLogger(WebAppExceptionBuilder.class);
    private String message;
    private Exception exception;
    private Response.Status status;
    private NewCookie newCookie;

    public WebAppExceptionBuilder() {
    }

    public WebAppExceptionBuilder(String msg, Exception ex, Response.Status code, NewCookie cookie) {
        if (ex != null) {
            this.exception(ex);
        }
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.message = msg;
        }
        if (code != null) {
            this.status = code;
        }
        this.newCookie = cookie;
    }

    public WebAppExceptionBuilder exception(Exception ex) {
        this.exception = ex;
        if (StringUtils.isBlank((CharSequence)this.message)) {
            this.message = ex.getMessage();
        }
        log.debug("exception() - excpetion:'{}'", (Object)ex.getClass().getSimpleName());
        if (ex instanceof OutcomeBuilderException || ex instanceof ObjectAlreadyExistsException || ex instanceof InvalidDataException || ex instanceof ScriptErrorException || ex instanceof ScriptingEngineException || ex instanceof InvalidItemPathException || ex instanceof ClassCastException || ex instanceof InvalidCollectionModification) {
            this.status = Response.Status.BAD_REQUEST;
        } else if (ex instanceof UnsupportedOperationException) {
            this.status = Response.Status.UNSUPPORTED_MEDIA_TYPE;
        } else if (ex instanceof AccessRightsException) {
            this.status = Response.Status.UNAUTHORIZED;
        } else if (ex instanceof ObjectNotFoundException) {
            this.status = Response.Status.NOT_FOUND;
        } else if (ex instanceof InvalidTransitionException) {
            this.status = Response.Status.CONFLICT;
        } else if (ex instanceof NotImplementedException) {
            this.status = Response.Status.NOT_IMPLEMENTED;
        } else if (ex instanceof PersistencyException || ex instanceof MarshalException || ex instanceof ValidationException || ex instanceof IOException || ex instanceof MappingException) {
            this.status = Response.Status.INTERNAL_SERVER_ERROR;
        } else if (ex instanceof WebApplicationException) {
            log.debug("exception() - DO NOTHING with WebApplicationException: {}", (Object)this.message);
        } else {
            log.debug("exception() - Mapping excpetion '{}' to INTERNAL_SERVER_ERROR", (Object)ex.getClass().getSimpleName());
            this.status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return this;
    }

    public WebAppExceptionBuilder message(String message) {
        this.message = message;
        return this;
    }

    public WebAppExceptionBuilder status(Response.Status status) {
        this.status = status;
        return this;
    }

    public WebAppExceptionBuilder newCookie(NewCookie newCookie) {
        this.newCookie = newCookie;
        return this;
    }

    public WebApplicationException build() {
        if (this.exception != null && this.exception instanceof WebApplicationException) {
            return (WebApplicationException)this.exception;
        }
        if (this.status == null) {
            this.status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        if (StringUtils.isBlank((CharSequence)this.message)) {
            this.message = "Application process failed";
        }
        log.debug("build() - msg:" + this.message + " status:" + this.status, (Throwable)this.exception);
        Response.ResponseBuilder responseBuilder = this.newCookie != null && this.status != Response.Status.UNAUTHORIZED ? Response.status((Response.Status)this.status).cookie(new NewCookie[]{this.newCookie}) : Response.status((Response.Status)this.status);
        if (Gateway.getProperties().getBoolean("REST.Debug.errorsWithBody", false)) {
            StringBuffer sb = new StringBuffer("[errorMessage]");
            sb.append(this.message).append("[/errorMessage]");
            if (this.exception != null) {
                sb.append(" - Exception:" + this.exception.getMessage());
            }
            return new WebApplicationException(sb.toString(), responseBuilder.entity((Object)this.message).build());
        }
        return new WebApplicationException(this.message, responseBuilder.build());
    }
}

