/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.util.LinkedHashMap;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.WebAppExceptionBuilder;

@Path(value="/item/{uuid}/viewpoint")
public class ItemViewpoint
extends ItemUtils {
    @GET
    @Produces(value={"application/json"})
    public Response getSchemas(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        return this.toJSON(this.enumerate(this.getProxy(uuid, cookie), ClusterType.VIEWPOINT, "viewpoint", uri, cookie), cookie).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}")
    public Response getViewNames(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        return this.toJSON(this.enumerate(this.getProxy(uuid, cookie), ClusterType.VIEWPOINT + "/" + schema, "viewpoint/" + schema, uri, cookie), cookie).build();
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="{schema}/{viewName}")
    public Response queryXMLData(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="viewName") String viewName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        return this.getViewpointOutcome(uuid, schema, viewName, false, cookie).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}/{viewName}")
    public Response queryJSONData(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="viewName") String viewName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        return this.getViewpointOutcome(uuid, schema, viewName, true, cookie).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}/{viewName}/event")
    public Response getViewEvent(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="viewName") String viewName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        try {
            Viewpoint view = item.getViewpoint(schema, viewName);
            Event ev = view.getEvent();
            return this.toJSON(this.makeEventData(ev, uri), cookie).build();
        }
        catch (InvalidDataException | ObjectNotFoundException | PersistencyException e) {
            throw new WebAppExceptionBuilder().message("Database error loading view " + viewName + " of schema " + schema).exception((Exception)e).newCookie(cookie).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}/{viewName}/history")
    public Response getAllEventsForView(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="viewName") String viewName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        try {
            History history = (History)item.getObject(ClusterType.HISTORY);
            history.activate();
            LinkedHashMap eventList = new LinkedHashMap();
            for (int i = 0; i <= history.getLastId(); ++i) {
                Event ev = history.get(Integer.valueOf(i));
                if (!schema.equals(ev.getSchemaName()) || !viewName.equals(ev.getViewName())) continue;
                String evId = String.valueOf(i);
                LinkedHashMap<String, Object> eventDetails = new LinkedHashMap<String, Object>();
                eventDetails.put("timestamp", ev.getTimeString());
                eventDetails.put("data", uri.getAbsolutePathBuilder().path(evId).build(new Object[0]));
                eventList.put(evId, eventDetails);
            }
            return this.toJSON(eventList, cookie).build();
        }
        catch (ObjectNotFoundException e) {
            throw new WebAppExceptionBuilder().message("Could not load History").exception((Exception)((Object)e)).newCookie(cookie).build();
        }
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="{schema}/{viewName}/history/{event}")
    public Response getOutcomeForEvent(@Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="viewName") String viewName, @PathParam(value="event") Integer eventId, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        Event ev;
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        try {
            ev = (Event)item.getObject(ClusterType.HISTORY + "/" + eventId);
        }
        catch (ObjectNotFoundException e) {
            throw new WebAppExceptionBuilder().message("Event " + eventId + " was not found").exception((Exception)((Object)e)).newCookie(cookie).build();
        }
        if (!schema.equals(ev.getSchemaName()) || !viewName.equals(ev.getViewName())) {
            throw new WebAppExceptionBuilder().message("Event does not belong to this data").status(Response.Status.BAD_REQUEST).newCookie(cookie).build();
        }
        try {
            Outcome oc = (Outcome)item.getObject(ClusterType.OUTCOME + "/" + schema + "/" + ev.getSchemaVersion() + "/" + eventId);
            return this.getOutcomeResponse(oc, ev, ItemViewpoint.produceJSON(headers.getAcceptableMediaTypes()), cookie).build();
        }
        catch (ObjectNotFoundException e) {
            throw new WebAppExceptionBuilder().message("Outcome " + eventId + " was not found").exception((Exception)((Object)e)).newCookie(cookie).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}/{viewName}/history/{event}/event")
    public Response getOutcomeEvent(@Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="viewName") String viewName, @PathParam(value="event") Integer eventId, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        try {
            Event ev = (Event)item.getObject(ClusterType.HISTORY + "/" + eventId);
            if (!schema.equals(ev.getSchemaName()) || !viewName.equals(ev.getViewName())) {
                throw new WebAppExceptionBuilder().message("Event does not belong to this data").status(Response.Status.BAD_REQUEST).newCookie(cookie).build();
            }
            return this.toJSON(this.makeEventData(ev, uri), cookie).build();
        }
        catch (ObjectNotFoundException e) {
            throw new WebAppExceptionBuilder().message("Event " + eventId + " was not found").exception((Exception)((Object)e)).newCookie(cookie).build();
        }
    }
}

