/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.util.Base64;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lifecycle.instance.predefined.agent.Login;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.security.SecurityManager;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.RestHandler;
import org.cristalise.restapi.WebAppExceptionBuilder;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="login")
public class CookieLogin
extends RestHandler {
    private static final Logger log = LoggerFactory.getLogger(CookieLogin.class);

    @GET
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response login(@Context HttpHeaders headers, @QueryParam(value="user") String user, @QueryParam(value="pass") String pass) {
        return this.processLogin(user, pass, headers);
    }

    private Response processLogin(String user, String pass, HttpHeaders headers) {
        try {
            log.debug("agent:'{}'", (Object)user);
            AgentProxy agent = Gateway.getSecurityManager().authenticate(user, pass, null);
            agent.execute((ItemProxy)agent, Login.class);
            return this.getCookieResponse(agent.getPath(), ItemUtils.produceJSON(headers.getAcceptableMediaTypes()));
        }
        catch (Exception ex) {
            String msg = SecurityManager.decodePublicSecurityMessage((Throwable)ex);
            if (StringUtils.isBlank((CharSequence)msg)) {
                msg = "Bad username/password";
            }
            log.debug("error:{}", (Object)msg);
            throw new WebAppExceptionBuilder().message(msg).status(Response.Status.UNAUTHORIZED).build();
        }
    }

    private synchronized Response getCookieResponse(AgentPath agentPath, boolean produceJSON) {
        try {
            NewCookie cookie = this.createNewCookie(agentPath);
            boolean tempPwd = Gateway.getLookup().getAgentPath(agentPath.getAgentName()).isPasswordTemporary();
            String result = "<Login result='Success' temporaryPassword='" + tempPwd + "' uuid='" + agentPath.getUUID() + "' />";
            if (produceJSON) {
                result = XML.toJSONObject((String)result, (boolean)true).toString();
            }
            return Response.ok((Object)result).cookie(new NewCookie[]{cookie}).build();
        }
        catch (Exception e) {
            log.error("Error creating cookie", (Throwable)e);
            throw new WebAppExceptionBuilder().message("Error creating cookie").status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Consumes(value={"text/plain", "text/xml", "application/xml", "application/json"})
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response postLogin(String postData, @Context HttpHeaders headers) {
        String pass;
        String user;
        try {
            if (StringUtils.isEmpty((CharSequence)postData)) {
                throw new Exception("Authentication data is null or empty");
            }
            JSONObject authData = new JSONObject(postData);
            user = this.decode(authData.getString("username"));
            pass = this.decode(authData.getString("password"));
            if (StringUtils.isEmpty((CharSequence)user) || StringUtils.isEmpty((CharSequence)pass)) {
                throw new Exception("Invalid username or password");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new WebAppExceptionBuilder().message("Problem logging in").status(Response.Status.BAD_REQUEST).build();
        }
        return this.processLogin(user, pass, headers);
    }

    private String decode(String encodedStr) {
        return new String(Base64.getDecoder().decode(encodedStr));
    }
}

