/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.AccessDeniedException;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcomebuilder.OutcomeBuilder;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.RestHandler;
import org.cristalise.restapi.ScriptUtils;
import org.cristalise.restapi.WebAppExceptionBuilder;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@javax.ws.rs.Path(value="/item/{uuid}")
public class ItemRoot
extends ItemUtils {
    private static final Logger log = LoggerFactory.getLogger(ItemRoot.class);
    private ScriptUtils scriptUtils = new ScriptUtils();

    @GET
    @javax.ws.rs.Path(value="name")
    @Produces(value={"text/plain"})
    public String getName(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        String name = this.getItemName(new ItemPath(UUID.fromString(uuid)));
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new WebAppExceptionBuilder().message("Cannot resolve UUID").status(Response.Status.NOT_FOUND).newCookie(cookie).build();
        }
        return name;
    }

    @GET
    @javax.ws.rs.Path(value="aliases")
    @Produces(value={"application/json"})
    public Response getAliases(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        Map<String, Object> itemAliases = this.makeItemDomainPathsData(new ItemPath(UUID.fromString(uuid)));
        if (StringUtils.isBlank((CharSequence)((String)itemAliases.get("name")))) {
            throw new WebAppExceptionBuilder().message("Cannot resolve UUID").status(Response.Status.NOT_FOUND).newCookie(cookie).build();
        }
        return this.toJSON(itemAliases, cookie).build();
    }

    @GET
    @javax.ws.rs.Path(value="master")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getMasterOutcome(@Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @QueryParam(value="schema") String schemaName, @QueryParam(value="schemaVersion") Integer schemaVersion, @QueryParam(value="script") String scriptName, @QueryParam(value="scriptVersion") Integer scriptVersion, @CookieParam(value="cauth") Cookie authCookie) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        try {
            Schema masterSchema = item.getMasterSchema(schemaName, schemaVersion);
            Script aggrScript = this.getAggregateScript(item, scriptName, scriptVersion);
            boolean jsonFlag = ItemRoot.produceJSON(headers.getAcceptableMediaTypes());
            if (aggrScript != null) {
                return this.scriptUtils.returnScriptResult(item, masterSchema, aggrScript, new CastorHashMap(), jsonFlag).cookie(new NewCookie[]{cookie}).build();
            }
            if (item.checkViewpoint(item.getType(), "last")) {
                return this.getViewpointOutcome(uuid, item.getType(), "last", true, cookie).build();
            }
            throw new WebAppExceptionBuilder().message("No method available to retrieve MasterOutcome").status(Response.Status.NOT_FOUND).newCookie(cookie).build();
        }
        catch (InvalidDataException | ObjectNotFoundException | ScriptingEngineException e) {
            throw new WebAppExceptionBuilder().message("Error retrieving MasterOutcome").status(Response.Status.NOT_FOUND).newCookie(cookie).build();
        }
        catch (UnsupportedOperationException e) {
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
    }

    private Script getAggregateScript(ItemProxy item) {
        return this.getAggregateScript(item, null, null);
    }

    private Script getAggregateScript(ItemProxy item, String name, Integer version) {
        try {
            return item.getAggregateScript();
        }
        catch (InvalidDataException | ObjectNotFoundException e) {
            return null;
        }
    }

    @GET
    @javax.ws.rs.Path(value="scriptResult")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getScriptResult(@Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @QueryParam(value="script") String scriptName, @QueryParam(value="version") Integer scriptVersion, @QueryParam(value="activityPath") String actPath, @QueryParam(value="inputs") String inputJson, @CookieParam(value="cauth") Cookie authCookie) {
        RestHandler.AuthData authData = this.checkAuthCookie(authCookie);
        NewCookie cookie = this.checkAndCreateNewCookie(authData);
        ItemProxy item = this.getProxy(uuid, cookie);
        try {
            AgentProxy agent = (AgentProxy)Gateway.getProxyManager().getProxy((Path)authData.agent);
            return this.scriptUtils.executeScript(headers, item, scriptName, scriptVersion, actPath, inputJson, (Map<String, Object>)ImmutableMap.of((Object)"agent", (Object)agent)).cookie(new NewCookie[]{cookie}).build();
        }
        catch (UnsupportedOperationException | AccessDeniedException | AccessRightsException | InvalidDataException | ObjectNotFoundException e) {
            throw new WebAppExceptionBuilder().exception((Exception)e).newCookie(cookie).build();
        }
    }

    @POST
    @javax.ws.rs.Path(value="scriptResult")
    @Consumes(value={"text/xml", "application/xml", "application/json", "text/plain"})
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getScriptResultPost(String postData, @Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @QueryParam(value="script") String scriptName, @QueryParam(value="version") Integer scriptVersion, @QueryParam(value="activityPath") String actPath, @CookieParam(value="cauth") Cookie authCookie) {
        RestHandler.AuthData authData = this.checkAuthCookie(authCookie);
        NewCookie cookie = this.checkAndCreateNewCookie(authData);
        ItemProxy item = this.getProxy(uuid, cookie);
        try {
            AgentProxy agent = (AgentProxy)Gateway.getProxyManager().getProxy((Path)authData.agent);
            return this.scriptUtils.executeScript(headers, item, scriptName, scriptVersion, actPath, postData, (Map<String, Object>)ImmutableMap.of((Object)"agent", (Object)agent)).cookie(new NewCookie[]{cookie}).build();
        }
        catch (UnsupportedOperationException | AccessDeniedException | AccessRightsException | InvalidDataException | ObjectNotFoundException e) {
            log.error("Exception caught in getScriptResultPost(uuid={}, scriptName={}, scriptVersion={}, actPath={}, postData={}", new Object[]{uuid, scriptName, scriptVersion, actPath, postData, e});
            throw new WebAppExceptionBuilder().exception((Exception)e).newCookie(cookie).build();
        }
    }

    @GET
    @javax.ws.rs.Path(value="queryResult")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getQueryResult(@Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @QueryParam(value="query") String queryName, @QueryParam(value="version") Integer queryVersion, @CookieParam(value="cauth") Cookie authCookie) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        if (queryVersion == null) {
            queryVersion = 0;
        }
        Query query = null;
        try {
            boolean jsonFlag = ItemRoot.produceJSON(headers.getAcceptableMediaTypes());
            if (queryName != null) {
                query = LocalObjectLoader.getQuery((String)queryName, (int)queryVersion);
                return this.returnQueryResult(queryName, item, null, query, jsonFlag).cookie(new NewCookie[]{cookie}).build();
            }
            throw new WebAppExceptionBuilder().message("Name or UUID of Query was missing").status(Response.Status.NOT_FOUND).newCookie(cookie).build();
        }
        catch (UnsupportedOperationException | InvalidDataException | ObjectNotFoundException | PersistencyException e) {
            throw new WebAppExceptionBuilder().exception((Exception)e).newCookie(cookie).build();
        }
    }

    private Response.ResponseBuilder returnQueryResult(String queryName, ItemProxy item, Object object, Query query, boolean jsonFlag) throws PersistencyException {
        String xmlResult = item.executeQuery(query);
        if (jsonFlag) {
            return Response.ok((Object)XML.toJSONObject((String)xmlResult, (boolean)true).toString());
        }
        return Response.ok((Object)xmlResult);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getItemSummary(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) throws Exception {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        Map<String, Object> itemSummary = this.makeItemDomainPathsData(item.getPath());
        itemSummary.put("uuid", uuid);
        itemSummary.put("hasMasterOutcome", false);
        try {
            String type = item.getType();
            if (type != null) {
                itemSummary.put("type", type);
                if (this.getAggregateScript(item) != null || item.checkViewpoint(type, "last")) {
                    itemSummary.put("hasMasterOutcome", true);
                    itemSummary.put("master", ItemRoot.getItemURI(uri, item, new Object[]{"master"}));
                }
            }
            itemSummary.put("properties", ItemRoot.getPropertySummary(item));
            itemSummary.put("viewpoints", this.getAllViewpoints(item, uri, cookie));
            itemSummary.put("collections", this.enumerate(item, ClusterType.COLLECTION, "collection", uri, cookie));
            itemSummary.put("workflow", ItemRoot.getItemURI(uri, item, new Object[]{"workflow"}));
            itemSummary.put("history", ItemRoot.getItemURI(uri, item, new Object[]{"history"}));
            itemSummary.put("outcome", ItemRoot.getItemURI(uri, item, new Object[]{"outcome"}));
            itemSummary.put("attachment", ItemRoot.getItemURI(uri, item, new Object[]{"attachment"}));
            return this.toJSON(itemSummary, cookie).build();
        }
        catch (ObjectNotFoundException e) {
            throw new WebAppExceptionBuilder().message("No Properties found").status(Response.Status.BAD_REQUEST).newCookie(cookie).build();
        }
        catch (Exception e) {
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
    }

    @GET
    @javax.ws.rs.Path(value="job")
    @Produces(value={"application/json"})
    public Response getJobs(@PathParam(value="uuid") String uuid, @QueryParam(value="agent") String agentName, @QueryParam(value="activityName") String activityName, @QueryParam(value="transitionName") String transitionName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        ArrayList jobList = null;
        Job job = null;
        try {
            AgentProxy agent = this.getAgent(agentName, authCookie);
            if (StringUtils.isNotBlank((CharSequence)activityName)) {
                job = StringUtils.isNotBlank((CharSequence)transitionName) ? item.getJobByTransitionName(activityName, transitionName, agent) : item.getJobByName(activityName, agent);
            } else {
                jobList = item.getJobList(agent);
            }
        }
        catch (Exception e) {
            throw new WebAppExceptionBuilder("Error loading joblist", e, null, cookie).build();
        }
        String itemName = item.getName();
        if (jobList != null) {
            ArrayList<LinkedHashMap<String, Object>> jobListData = new ArrayList<LinkedHashMap<String, Object>>();
            for (Job j : jobList) {
                jobListData.add(this.makeJobData(j, itemName, uri));
            }
            return this.toJSON(jobListData, cookie).build();
        }
        if (job != null) {
            return this.toJSON(this.makeJobData(job, itemName, uri), cookie).build();
        }
        throw new WebAppExceptionBuilder().message("No job found for actName:" + activityName + " transName:" + transitionName).status(Response.Status.NOT_FOUND).newCookie(cookie).build();
    }

    @POST
    @Consumes(value={"text/plain", "text/xml", "application/xml", "application/json"})
    @Produces(value={"text/xml", "application/xml", "application/json"})
    @javax.ws.rs.Path(value="{activityPath: .*}")
    public String requestTransition(String outcome, @Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @PathParam(value="activityPath") String actPath, @QueryParam(value="transition") String transition, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        if (actPath == null) {
            throw new WebAppExceptionBuilder().message("Must specify activity path").status(Response.Status.BAD_REQUEST).newCookie(cookie).build();
        }
        log.info("requestTransition({}://{})", (Object)item, (Object)actPath);
        try {
            String executeResult;
            String contentType = (String)headers.getRequestHeader("Content-Type").get(0);
            log.debug("requestTransition() outcome:'{}' contentType:'{}'", (Object)outcome, (Object)contentType);
            AgentProxy agent = Gateway.getProxyManager().getAgentProxy(this.getAgentPath(authCookie));
            if (actPath.startsWith("workflow/predefined/")) {
                executeResult = this.executePredefinedStep(item, outcome, contentType, actPath, agent);
            } else {
                transition = this.extractAndCheckTransitionName(transition, uri);
                executeResult = this.executeJob(item, outcome, contentType, actPath, transition, agent);
            }
            if (ItemRoot.produceJSON(headers.getAcceptableMediaTypes())) {
                return XML.toJSONObject((String)executeResult, (boolean)true).toString();
            }
            return executeResult;
        }
        catch (Exception e) {
            log.debug("requestTransition({}://{}) - outcome:'{}'", new Object[]{item, actPath, outcome});
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/xml", "application/xml", "application/json"})
    @javax.ws.rs.Path(value="{binaryUploadPath: .*}")
    public String requestBinaryTransition(FormDataMultiPart body, @Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @PathParam(value="binaryUploadPath") String actPath, @QueryParam(value="transition") String transition, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        log.info("requestBinaryTransition({}://{})", (Object)item, (Object)actPath);
        if (actPath == null) {
            throw new WebAppExceptionBuilder().message("Must specify activity path").status(Response.Status.BAD_REQUEST).newCookie(cookie).build();
        }
        String outcome = null;
        try {
            String executeResult;
            AgentProxy agent = Gateway.getProxyManager().getAgentProxy(this.getAgentPath(authCookie));
            FormDataBodyPart outcomeBodyPart = body.getField("outcome");
            String outcomeType = "application/json";
            if (outcomeBodyPart != null) {
                outcome = outcomeBodyPart.getValue();
                if (outcome.startsWith("<")) {
                    outcomeType = "application/xml";
                }
                log.debug("requestBinaryTransition() - outcome:'{}' contentType:'{}'", (Object)outcome, (Object)outcomeType);
            }
            FormDataBodyPart fileBodyPart = body.getField("file");
            InputStream file = null;
            String fileName = null;
            if (fileBodyPart != null) {
                file = (InputStream)fileBodyPart.getValueAs(InputStream.class);
                fileName = fileBodyPart.getContentDisposition().getFileName();
                log.debug("requestBinaryTransition() - attachment fileName:'{}'", (Object)fileName);
            }
            if (actPath.startsWith("workflow/predefined/")) {
                if (file != null) {
                    throw new WebAppExceptionBuilder().message("PredefinedStep '" + actPath + "' cannot have attahcment").status(Response.Status.BAD_REQUEST).newCookie(cookie).build();
                }
                executeResult = this.executePredefinedStep(item, outcome, outcomeType, actPath, agent);
            } else {
                transition = this.extractAndCheckTransitionName(transition, uri);
                executeResult = this.executeJob(item, outcome, outcomeType, file, fileName, actPath, transition, agent);
            }
            if (ItemRoot.produceJSON(headers.getAcceptableMediaTypes())) {
                return XML.toJSONObject((String)executeResult, (boolean)true).toString();
            }
            return executeResult;
        }
        catch (Exception e) {
            log.debug("requestBinaryTransition({}://{}) - outcome:'{}'", new Object[]{item, actPath, outcome});
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="job/formTemplate/{activityPath: .*}")
    public Response getJobFormTemplate(@Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @PathParam(value="activityPath") String actPath, @QueryParam(value="transition") String transition, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        if (actPath == null) {
            throw new WebAppExceptionBuilder().message("Must specify activity path").status(Response.Status.BAD_REQUEST).newCookie(cookie).build();
        }
        try {
            AgentProxy agent;
            if (actPath.startsWith("workflow/predefined/")) {
                throw new WebAppExceptionBuilder().message("Unimplemented").status(Response.Status.BAD_REQUEST).newCookie(cookie).build();
            }
            Job thisJob = item.getJobByTransitionName(actPath, transition = this.extractAndCheckTransitionName(transition, uri), agent = Gateway.getProxyManager().getAgentProxy(this.getAgentPath(authCookie)));
            if (thisJob == null) {
                throw new WebAppExceptionBuilder().message("Job not found for actPath:" + actPath + " transition:" + transition).status(Response.Status.NOT_FOUND).newCookie(cookie).build();
            }
            CastorHashMap inputs = (CastorHashMap)thisJob.getActProps().clone();
            inputs.put((Object)"agent", (Object)agent);
            inputs.put((Object)"item", (Object)item);
            inputs.put((Object)"job", (Object)thisJob);
            if (thisJob.hasOutcome()) {
                return Response.ok((Object)new OutcomeBuilder(thisJob.getSchema(), false).generateNgDynamicForms((Map)inputs)).cookie(new NewCookie[]{cookie}).build();
            }
            log.debug("getJobFormTemplate() - no outcome needed for job:{}", (Object)thisJob);
            return Response.noContent().cookie(new NewCookie[]{cookie}).build();
        }
        catch (Exception e) {
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
    }

    private String extractAndCheckTransitionName(String transName, UriInfo uri) throws InvalidDataException {
        if (StringUtils.isNotBlank((CharSequence)transName)) {
            return transName;
        }
        for (String key : uri.getQueryParameters().keySet()) {
            List qparams = (List)uri.getQueryParameters().get((Object)key);
            if (qparams.size() != 1 || ((String)qparams.get(0)).length() != 0) continue;
            return key;
        }
        throw new InvalidDataException("Must specify transition name");
    }
}

