/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.cristalise.kernel.common.AccessDeniedException;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.restapi.ResourceAccess;
import org.cristalise.restapi.RestHandler;
import org.cristalise.restapi.ScriptUtils;
import org.cristalise.restapi.WebAppExceptionBuilder;
import org.cristalise.storage.jooqdb.JooqDataSourceHandler;
import org.jooq.DSLContext;
import org.jooq.exception.DataAccessException;

@javax.ws.rs.Path(value="/script")
public class ScriptAccess
extends ResourceAccess {
    private ScriptUtils scriptUtils = new ScriptUtils();

    @GET
    @Produces(value={"application/json"})
    public Response listAllScripts(@DefaultValue(value="0") @QueryParam(value="start") Integer start, @QueryParam(value="batch") Integer batchSize, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        RestHandler.AuthData authData = this.checkAuthCookie(authCookie);
        if (batchSize == null) {
            batchSize = Gateway.getProperties().getInt("REST.DefaultBatchSize", 75);
        }
        NewCookie cookie = this.checkAndCreateNewCookie(authData);
        return this.listAllResources(BuiltInResources.SCRIPT_RESOURCE, uri, start, batchSize, cookie).build();
    }

    @GET
    @javax.ws.rs.Path(value="{name}")
    @Produces(value={"application/json"})
    public Response listScriptVersions(@PathParam(value="name") String name, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        RestHandler.AuthData authData = this.checkAuthCookie(authCookie);
        NewCookie cookie = this.checkAndCreateNewCookie(authData);
        return this.listResourceVersions(BuiltInResources.SCRIPT_RESOURCE, name, uri, cookie).build();
    }

    @GET
    @javax.ws.rs.Path(value="{name}/{version}")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getScript(@Context HttpHeaders headers, @PathParam(value="name") String name, @PathParam(value="version") Integer version, @CookieParam(value="cauth") Cookie authCookie) {
        RestHandler.AuthData authData = this.checkAuthCookie(authCookie);
        NewCookie cookie = this.checkAndCreateNewCookie(authData);
        return this.getResource(BuiltInResources.SCRIPT_RESOURCE, name, version, ScriptAccess.produceJSON(headers.getAcceptableMediaTypes()), cookie).build();
    }

    @GET
    @javax.ws.rs.Path(value="scriptResult")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getScriptResult(@Context HttpHeaders headers, @QueryParam(value="script") String scriptName, @QueryParam(value="version") Integer scriptVersion, @QueryParam(value="inputs") String inputJson, @CookieParam(value="cauth") Cookie authCookie) {
        RestHandler.AuthData authData = this.checkAuthCookie(authCookie);
        NewCookie cookie = this.checkAndCreateNewCookie(authData);
        return this.handleScriptExecution(headers, scriptName, scriptVersion, inputJson, cookie, authData.agent);
    }

    @POST
    @javax.ws.rs.Path(value="scriptResult")
    @Consumes(value={"text/xml", "application/xml", "application/json"})
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getScriptResultPost(String postData, @Context HttpHeaders headers, @QueryParam(value="script") String scriptName, @QueryParam(value="version") Integer scriptVersion, @CookieParam(value="cauth") Cookie authCookie) {
        RestHandler.AuthData authData = this.checkAuthCookie(authCookie);
        NewCookie cookie = this.checkAndCreateNewCookie(authData);
        return this.handleScriptExecution(headers, scriptName, scriptVersion, postData, cookie, authData.agent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response handleScriptExecution(HttpHeaders headers, String scriptName, Integer scriptVersion, String inputJson, NewCookie cookie, AgentPath agentPath) {
        try (DSLContext context = JooqDataSourceHandler.retrieveContext(null);){
            AgentProxy agent = (AgentProxy)Gateway.getProxyManager().getProxy((Path)agentPath);
            Response response = this.scriptUtils.executeScript(headers, null, scriptName, scriptVersion, null, inputJson, (Map<String, Object>)ImmutableMap.of((Object)"dsl", (Object)context, (Object)"agent", (Object)agent)).cookie(new NewCookie[]{cookie}).build();
            return response;
        }
        catch (UnsupportedOperationException | AccessDeniedException | AccessRightsException | InvalidDataException | ObjectNotFoundException e) {
            throw new WebAppExceptionBuilder().exception((Exception)e).newCookie(cookie).build();
        }
        catch (PersistencyException | DataAccessException e) {
            throw new WebAppExceptionBuilder("Error connecting to database, please contact support", (Exception)e, Response.Status.NOT_FOUND, cookie).build();
        }
    }
}

