/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.net.URLDecoder;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.AccessDeniedException;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.security.SecurityManager;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.restapi.ItemUtils;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptUtils
extends ItemUtils {
    private static final Logger log = LoggerFactory.getLogger(ScriptUtils.class);
    static Semaphore mutex = new Semaphore(1);

    protected Object executeScript(ItemProxy item, Script script, CastorHashMap inputs) throws ScriptingEngineException, InvalidDataException {
        Object scriptResult = null;
        try {
            scriptResult = script.evaluate(item == null ? script.getItemPath() : item.getPath(), inputs, null, null);
        }
        catch (ScriptingEngineException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidDataException(e.getMessage());
        }
        return scriptResult;
    }

    public Response.ResponseBuilder executeScript(HttpHeaders headers, ItemProxy item, String scriptName, Integer scriptVersion, String actPath, String inputJson, Map<String, Object> additionalInputs) throws ObjectNotFoundException, UnsupportedOperationException, InvalidDataException, AccessRightsException, AccessDeniedException {
        if (scriptVersion == null) {
            if (Gateway.getProperties().getBoolean("Module.Versioning.strict", false)) {
                throw new InvalidDataException("Version for Script '" + scriptName + "' cannot be null");
            }
            log.warn("executeScript() - Version for Script {}' was null, using version 0 as default", (Object)scriptName);
            scriptVersion = 0;
        }
        if (scriptName != null) {
            try {
                Script script = LocalObjectLoader.getScript((String)scriptName, (int)scriptVersion);
                SecurityManager secMan = Gateway.getSecurityManager();
                if (secMan.isShiroEnabled()) {
                    AgentProxy agentProxy = (AgentProxy)additionalInputs.get("agent");
                    if (null == agentProxy) {
                        throw new AccessRightsException("Input parameter 'agent' was not specified");
                    }
                    AgentPath agentPath = agentProxy.getPath();
                    if (!secMan.checkPermissions(agentPath, SecurityManager.BuiltInAction.ACTION_EXECUTE, script.getItemPath(), null)) {
                        if (log.isTraceEnabled()) {
                            for (RolePath role : agentPath.getRoles()) {
                                log.error(role.dump());
                            }
                        }
                        throw new AccessDeniedException("'" + agentPath.getAgentName() + "' is NOT permitted to " + SecurityManager.BuiltInAction.ACTION_EXECUTE + " script: " + script.getName());
                    }
                }
                JSONObject json = new JSONObject(inputJson == null ? "{}" : URLDecoder.decode(inputJson, "UTF-8"));
                CastorHashMap inputs = new CastorHashMap();
                for (String key : json.keySet()) {
                    inputs.put((Object)key, json.get(key));
                }
                if (StringUtils.isNotBlank((CharSequence)actPath)) {
                    inputs.put((Object)"activityPath", (Object)actPath);
                }
                inputs.putAll(additionalInputs);
                return this.returnScriptResult(item, null, script, inputs, ScriptUtils.produceJSON(headers.getAcceptableMediaTypes()));
            }
            catch (UnsupportedOperationException | AccessDeniedException | AccessRightsException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("Error executing script, please contact support", (Throwable)e);
                if (e.getMessage().contains("[errorMessage]")) {
                    throw new ObjectNotFoundException(e.getMessage());
                }
                throw new ObjectNotFoundException("Error executing script, please contact support");
            }
        }
        throw new ObjectNotFoundException("Name or UUID of Script was missing");
    }

    public Response.ResponseBuilder returnScriptResult(ItemProxy item, Schema schema, Script script, CastorHashMap inputs, boolean jsonFlag) throws ScriptingEngineException, InvalidDataException {
        try {
            mutex.acquire();
            Response.ResponseBuilder responseBuilder = this.runScript(item, schema, script, inputs, jsonFlag);
            return responseBuilder;
        }
        catch (ScriptingEngineException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidDataException(e.getMessage());
        }
        finally {
            mutex.release();
        }
    }

    protected Response.ResponseBuilder runScript(ItemProxy item, Schema schema, Script script, CastorHashMap inputs, boolean jsonFlag) throws ScriptingEngineException, InvalidDataException, ObjectNotFoundException {
        String xmlOutcome = null;
        Object scriptResult = this.executeScript(item, script, inputs);
        if (scriptResult instanceof String) {
            xmlOutcome = (String)scriptResult;
        } else if (scriptResult instanceof Map) {
            String key = ((Map)scriptResult).keySet().toArray(new String[0])[0];
            xmlOutcome = (String)((Map)scriptResult).get(key);
        } else {
            throw new ObjectNotFoundException("Cannot handle result of script:" + script.getName());
        }
        if (xmlOutcome == null) {
            throw new ObjectNotFoundException("Cannot handle result of script:" + script.getName());
        }
        if (schema != null) {
            return this.getOutcomeResponse(new Outcome(xmlOutcome, schema), new Date(), jsonFlag, null);
        }
        if (jsonFlag) {
            return Response.ok((Object)XML.toJSONObject((String)xmlOutcome, (boolean)true).toString());
        }
        return Response.ok((Object)xmlOutcome);
    }
}

