/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcomebuilder.OutcomeBuilder;
import org.cristalise.kernel.persistency.outcomebuilder.OutcomeBuilderException;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.RestHandler;
import org.cristalise.restapi.ScriptUtils;
import org.cristalise.restapi.SystemProperties;
import org.cristalise.restapi.WebAppExceptionBuilder;
import org.json.JSONArray;

@Path(value="/item/{uuid}/collection")
public class ItemCollection
extends ItemUtils {
    private ScriptUtils scriptUtils = new ScriptUtils();

    @GET
    @Produces(value={"application/json"})
    public Response getCollections(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        return this.toJSON(this.enumerate(item, ClusterType.COLLECTION, "collection", uri, cookie), cookie).build();
    }

    @GET
    @Path(value="{name}")
    @Produces(value={"application/json"})
    public Response getLastCollection(@PathParam(value="uuid") String uuid, @PathParam(value="name") String collName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        try {
            return this.toJSON(this.makeCollectionData(item.getCollection(collName), uri), cookie).build();
        }
        catch (ObjectNotFoundException e) {
            throw new WebAppExceptionBuilder().exception((Exception)((Object)e)).newCookie(cookie).build();
        }
    }

    @GET
    @Path(value="{name}/version")
    public Response getCollectionVersions(@PathParam(value="uuid") String uuid, @PathParam(value="name") String collName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        return this.toJSON(this.enumerate(item, String.valueOf(ClusterType.COLLECTION) + "/" + collName, "collection/" + collName + "/version", uri, cookie), cookie).build();
    }

    @GET
    @Path(value="{name}/version/{version}")
    public Response getCollectionVersion(@PathParam(value="uuid") String uuid, @PathParam(value="name") String collName, @PathParam(value="version") String collVersion, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        Integer version = collVersion.equals("last") ? null : Integer.valueOf(collVersion);
        try {
            LinkedHashMap<String, Object> collData = this.makeCollectionData(item.getCollection(collName, version), uri);
            return this.toJSON(collData, cookie).build();
        }
        catch (ObjectNotFoundException e) {
            throw new WebAppExceptionBuilder().exception((Exception)((Object)e)).newCookie(cookie).build();
        }
    }

    @GET
    @Path(value="{name}/formTemplate")
    @Produces(value={"application/json"})
    public Response getCollectionUpdateFormTemplate(@PathParam(value="uuid") String uuid, @PathParam(value="name") String collName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        RestHandler.AuthData authData = this.checkAuthCookie(authCookie);
        NewCookie cookie = this.checkAndCreateNewCookie(authData);
        ItemProxy item = this.getProxy(uuid, cookie);
        try {
            String[] lovInfo;
            Dependency dep = (Dependency)item.getCollection(collName);
            HashMap<String, Object> inputs = new HashMap<String, Object>();
            String lovProp = (String)dep.getProperties().get((Object)"ListOfValues");
            if (StringUtils.isNotBlank((CharSequence)lovProp) && "ScriptRef".equals((lovInfo = lovProp.split(":"))[0])) {
                Script script = LocalObjectLoader.getScript((String)lovInfo[1], (int)Integer.valueOf(lovInfo[2]));
                Map result = (Map)this.scriptUtils.executeScript(item, script, null);
                result.remove(null);
                TreeMap valuesToCaptions = new TreeMap(result);
                inputs.put("memberNames", valuesToCaptions);
            }
            if (inputs.isEmpty()) {
                List<String> names = ItemCollection.getItemNames(dep.getClassProperties());
                if (SystemProperties.REST_CollectionForm_checkInputs.getBoolean().booleanValue() && names.size() == 0) {
                    throw new WebAppExceptionBuilder().message("No Item was found").status(Response.Status.NOT_FOUND).newCookie(cookie).build();
                }
                inputs.put("memberNames", names);
            }
            AgentProxy agent = Gateway.getAgentProxy((AgentPath)authData.agent);
            inputs.put("agent", agent);
            inputs.put("item", item);
            String[] schemaInfo = ((String)dep.getProperties().get((Object)"MemberUpdateSchema")).split(":");
            Schema schema = LocalObjectLoader.getSchema((String)schemaInfo[0], (int)Integer.valueOf(schemaInfo[1]));
            JSONArray formJson = new OutcomeBuilder(schema, false).generateNgDynamicFormsJson(inputs);
            return Response.ok((Object)formJson.toString()).cookie(new NewCookie[]{cookie}).build();
        }
        catch (NumberFormatException | InvalidDataException | ObjectNotFoundException | OutcomeBuilderException | ScriptingEngineException e) {
            throw new WebAppExceptionBuilder().exception((Exception)e).newCookie(cookie).build();
        }
    }
}

