/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import java.io.ByteArrayInputStream;
import java.net.URLConnection;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.OutcomeAttachment;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.WebAppExceptionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/item/{uuid}/attachment")
public class ItemOutcomeAttachment
extends ItemUtils {
    private static final Logger log = LoggerFactory.getLogger(ItemOutcomeAttachment.class);

    @GET
    @Produces(value={"application/json"})
    public Response getOutcomeSchemas(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        return this.toJSON(this.enumerate(item, ClusterType.ATTACHMENT, "attachment", uri, cookie), cookie).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}")
    public Response getOutcomeVersions(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        return this.toJSON(this.enumerate(item, String.valueOf(ClusterType.ATTACHMENT) + "/" + schema, "attachment/" + schema, uri, cookie), cookie).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{schema}/{version}")
    public Response getOutcomeEvents(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="version") Integer version, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        return this.toJSON(this.enumerate(item, String.valueOf(ClusterType.ATTACHMENT) + "/" + schema + "/" + version, "attachment/" + schema + "/" + version, uri, cookie), cookie).build();
    }

    @GET
    @Produces(value={"application/octet-stream"})
    @Path(value="{schema}/{version}/{event}")
    public Response queryBinaryData(@PathParam(value="uuid") String uuid, @PathParam(value="schema") String schema, @PathParam(value="version") Integer version, @PathParam(value="event") Integer event, @QueryParam(value="inline") String inline, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        log.debug("queryBinaryData() - {}/{}/{}/{}", new Object[]{item, schema, version, event});
        try {
            OutcomeAttachment attachment = item.getOutcomeAttachment(schema, version.intValue(), event.intValue());
            String fileName = attachment.getFileName();
            String mimeType = "application/octet-stream";
            Object contentDisposition = "attachment;";
            if (StringUtils.isNotBlank((CharSequence)fileName)) {
                if (inline != null) {
                    contentDisposition = "inline;";
                    mimeType = "guessContent".equals(inline) ? URLConnection.guessContentTypeFromStream(new ByteArrayInputStream(attachment.getBinaryData())) : URLConnection.getFileNameMap().getContentTypeFor(fileName);
                }
                contentDisposition = (String)contentDisposition + " filename=\"" + fileName + "\"";
                log.debug("queryBinaryData() - {} : {}", (Object)mimeType, contentDisposition);
            }
            return Response.ok((Object)attachment.getBinaryData()).type(mimeType).header("Content-Disposition", contentDisposition).build();
        }
        catch (Exception e) {
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
    }
}

