/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.CriseVertxException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.Job;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcomebuilder.GeneratedFormType;
import org.cristalise.kernel.persistency.outcomebuilder.OutcomeBuilder;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.restapi.ItemUtils;
import org.cristalise.restapi.ScriptUtils;
import org.cristalise.restapi.WebAppExceptionBuilder;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.json.JSONArray;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/item/{uuid}")
public class ItemRoot
extends ItemUtils {
    private static final Logger log = LoggerFactory.getLogger(ItemRoot.class);
    private ScriptUtils scriptUtils = new ScriptUtils();

    @GET
    @Path(value="name")
    @Produces(value={"text/plain"})
    public String getName(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        String name = this.getItemName(new ItemPath(UUID.fromString(uuid)));
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new WebAppExceptionBuilder().message("Cannot resolve UUID").status(Response.Status.NOT_FOUND).newCookie(cookie).build();
        }
        return name;
    }

    @GET
    @Path(value="aliases")
    @Produces(value={"application/json"})
    public Response getAliases(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        Map<String, Object> itemAliases = this.makeItemDomainPathsData(new ItemPath(UUID.fromString(uuid)));
        if (StringUtils.isBlank((CharSequence)((String)itemAliases.get("name")))) {
            throw new WebAppExceptionBuilder().message("Cannot resolve UUID").status(Response.Status.NOT_FOUND).newCookie(cookie).build();
        }
        return this.toJSON(itemAliases, cookie).build();
    }

    @GET
    @Path(value="master")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getMasterOutcome(@Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @QueryParam(value="schema") String schemaName, @QueryParam(value="schemaVersion") Integer schemaVersion, @QueryParam(value="script") String scriptName, @QueryParam(value="scriptVersion") Integer scriptVersion, @CookieParam(value="cauth") Cookie authCookie) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        try {
            Schema masterSchema = item.getMasterSchema(schemaName, schemaVersion);
            Script aggrScript = this.getAggregateScript(item, scriptName, scriptVersion);
            boolean jsonFlag = ItemRoot.produceJSON(headers.getAcceptableMediaTypes());
            if (aggrScript != null) {
                return this.scriptUtils.returnScriptResult(item, masterSchema, aggrScript, new CastorHashMap(), jsonFlag).cookie(new NewCookie[]{cookie}).build();
            }
            if (item.checkViewpoint(item.getType(), "last")) {
                return this.getViewpointOutcome(uuid, item.getType(), "last", true, cookie).build();
            }
            throw new WebAppExceptionBuilder().message("No method available to retrieve MasterOutcome").status(Response.Status.NOT_FOUND).newCookie(cookie).build();
        }
        catch (InvalidDataException | ObjectNotFoundException | ScriptingEngineException e) {
            throw new WebAppExceptionBuilder().message("Error retrieving MasterOutcome").status(Response.Status.NOT_FOUND).newCookie(cookie).build();
        }
        catch (Exception e) {
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
    }

    private Script getAggregateScript(ItemProxy item) {
        return this.getAggregateScript(item, null, null);
    }

    private Script getAggregateScript(ItemProxy item, String name, Integer version) {
        if ("Factory".equals(item.getType())) {
            log.warn("getAggregateScript() - Return null for Factory item:{}", (Object)item);
            return null;
        }
        try {
            return item.getAggregateScript(name, version);
        }
        catch (InvalidDataException | ObjectNotFoundException e) {
            log.trace("getAggregateScript() - Return null for item:{}", (Object)item, (Object)e);
            return null;
        }
    }

    @GET
    @Path(value="scriptResult")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getScriptResult(@Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @QueryParam(value="script") String scriptName, @QueryParam(value="version") Integer scriptVersion, @QueryParam(value="activityPath") String actPath, @QueryParam(value="inputs") String inputJson, @CookieParam(value="cauth") Cookie authCookie) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        try {
            return this.scriptUtils.executeScript(headers, item, scriptName, scriptVersion, actPath, inputJson, (Map<String, Object>)ImmutableMap.of()).cookie(new NewCookie[]{cookie}).build();
        }
        catch (Exception e) {
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
        catch (Throwable t) {
            log.error("getScriptResult() - could not execute {}://{}'", new Object[]{item, scriptName, t});
            throw new WebAppExceptionBuilder().exception((Exception)new CriseVertxException(t)).newCookie(cookie).build();
        }
    }

    @POST
    @Path(value="scriptResult")
    @Consumes(value={"text/xml", "application/xml", "application/json", "text/plain"})
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getScriptResultPost(String postData, @Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @QueryParam(value="script") String scriptName, @QueryParam(value="version") Integer scriptVersion, @QueryParam(value="activityPath") String actPath, @CookieParam(value="cauth") Cookie authCookie) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        try {
            return this.scriptUtils.executeScript(headers, item, scriptName, scriptVersion, actPath, postData, (Map<String, Object>)ImmutableMap.of()).cookie(new NewCookie[]{cookie}).build();
        }
        catch (Exception e) {
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
        catch (Throwable t) {
            log.error("getScriptResultPost() - could not execute {}://{}'", new Object[]{item, scriptName, t});
            throw new WebAppExceptionBuilder().exception((Exception)new CriseVertxException(t)).newCookie(cookie).build();
        }
    }

    @GET
    @Path(value="queryResult")
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Response getQueryResult(@Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @QueryParam(value="query") String queryName, @QueryParam(value="version") Integer queryVersion, @CookieParam(value="cauth") Cookie authCookie) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        if (queryVersion == null) {
            queryVersion = 0;
        }
        Query query = null;
        try {
            boolean jsonFlag = ItemRoot.produceJSON(headers.getAcceptableMediaTypes());
            if (queryName != null) {
                query = LocalObjectLoader.getQuery((String)queryName, (int)queryVersion);
                return this.returnQueryResult(queryName, item, null, query, jsonFlag).cookie(new NewCookie[]{cookie}).build();
            }
            throw new WebAppExceptionBuilder().message("Name or UUID of Query was missing").status(Response.Status.NOT_FOUND).newCookie(cookie).build();
        }
        catch (Exception e) {
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
    }

    private Response.ResponseBuilder returnQueryResult(String queryName, ItemProxy item, Object object, Query query, boolean jsonFlag) throws PersistencyException {
        String xmlResult = item.executeQuery(query);
        if (jsonFlag) {
            return Response.ok((Object)XML.toJSONObject((String)xmlResult, (boolean)true).toString());
        }
        return Response.ok((Object)xmlResult);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getItemSummary(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) throws Exception {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        Map<String, Object> itemSummary = this.makeItemDomainPathsData(item.getPath());
        itemSummary.put("uuid", uuid);
        itemSummary.put("hasMasterOutcome", false);
        itemSummary.put("isAgent", item.getPath() instanceof AgentPath);
        try {
            String type = item.getType();
            if (type != null) {
                itemSummary.put("type", type);
                if (this.getAggregateScript(item) != null || item.checkViewpoint(type, "last")) {
                    itemSummary.put("hasMasterOutcome", true);
                    itemSummary.put("master", ItemRoot.getItemURI(uri, item, new Object[]{"master"}));
                }
            }
            itemSummary.put("properties", ItemRoot.getPropertySummary(item));
            itemSummary.put("viewpoints", this.getAllViewpoints(item, uri, cookie));
            itemSummary.put("collections", this.enumerate(item, ClusterType.COLLECTION, "collection", uri, cookie));
            itemSummary.put("workflow", ItemRoot.getItemURI(uri, item, new Object[]{"workflow"}));
            itemSummary.put("history", ItemRoot.getItemURI(uri, item, new Object[]{"history"}));
            itemSummary.put("outcome", ItemRoot.getItemURI(uri, item, new Object[]{"outcome"}));
            itemSummary.put("attachment", ItemRoot.getItemURI(uri, item, new Object[]{"attachment"}));
            itemSummary.put("job", ItemRoot.getItemURI(uri, item, new Object[]{"job"}));
            if (item.getPath() instanceof AgentPath) {
                itemSummary.put("roles", ItemRoot.getItemURI(uri, item, new Object[]{"roles"}));
            }
            return this.toJSON(itemSummary, cookie).build();
        }
        catch (ObjectNotFoundException e) {
            throw new WebAppExceptionBuilder().message("No Properties found").status(Response.Status.BAD_REQUEST).newCookie(cookie).build();
        }
        catch (Exception e) {
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
    }

    @GET
    @Path(value="job")
    @Produces(value={"application/json"})
    public Response getJobs(@PathParam(value="uuid") String uuid, @QueryParam(value="agent") String agentName, @QueryParam(value="activityName") String activityName, @QueryParam(value="transitionName") String transitionName, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        List jobList = null;
        Job job = null;
        try {
            AgentProxy agent = this.getAgent(agentName, authCookie);
            if (StringUtils.isNotBlank((CharSequence)activityName)) {
                job = StringUtils.isNotBlank((CharSequence)transitionName) ? item.getJobByTransitionName(activityName, transitionName, agent) : item.getJobByName(activityName, agent);
            } else {
                jobList = item.getJobs(agent);
            }
        }
        catch (Exception e) {
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
        if (jobList != null) {
            ArrayList<LinkedHashMap<String, Object>> jobListData = new ArrayList<LinkedHashMap<String, Object>>();
            for (Job j : jobList) {
                jobListData.add(this.makeJobData(j, item, uri));
            }
            return this.toJSON(jobListData, cookie).build();
        }
        if (job != null) {
            return this.toJSON(this.makeJobData(job, item, uri), cookie).build();
        }
        throw new WebAppExceptionBuilder().message("No job found for actName:" + activityName + " transName:" + transitionName).status(Response.Status.NOT_FOUND).newCookie(cookie).build();
    }

    @POST
    @Consumes(value={"text/plain", "text/xml", "application/xml", "application/json"})
    @Produces(value={"text/xml", "application/xml", "application/json"})
    @Path(value="{activityPath: .*}")
    public String requestTransition(String outcome, @Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @PathParam(value="activityPath") String actPath, @QueryParam(value="transition") String transition, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        if (actPath == null) {
            throw new WebAppExceptionBuilder().message("Must specify activity path").status(Response.Status.BAD_REQUEST).newCookie(cookie).build();
        }
        log.info("requestTransition() - {}://{}:{}", new Object[]{item, actPath, transition});
        try {
            String executeResult;
            String contentType = (String)headers.getRequestHeader("Content-Type").get(0);
            log.debug("requestTransition() outcome:'{}' contentType:'{}'", (Object)outcome, (Object)contentType);
            AgentProxy agent = Gateway.getAgentProxy((AgentPath)this.getAgentPath(authCookie));
            if (actPath.startsWith("workflow/predefined/")) {
                executeResult = this.executePredefinedStep(item, outcome, contentType, actPath, agent);
            } else {
                transition = this.extractAndCheckTransitionName(transition, uri);
                executeResult = this.executeJob(item, outcome, contentType, actPath, transition, agent);
            }
            if (ItemRoot.produceJSON(headers.getAcceptableMediaTypes())) {
                return XML.toJSONObject((String)executeResult, (boolean)true).toString();
            }
            return executeResult;
        }
        catch (Exception e) {
            log.error("requestTransition() - could not execute {}://{}:{}'", new Object[]{item, actPath, transition, e});
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
        catch (Throwable t) {
            log.error("requestTransition() - could not execute {}://{}:{}'", new Object[]{item, actPath, transition, t});
            throw new WebAppExceptionBuilder().exception((Exception)new CriseVertxException(t)).newCookie(cookie).build();
        }
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/xml", "application/xml", "application/json"})
    @Path(value="{binaryUploadPath: .*}")
    public String requestBinaryTransition(FormDataMultiPart body, @Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @PathParam(value="binaryUploadPath") String actPath, @QueryParam(value="transition") String transition, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        log.info("requestBinaryTransition() - {}://{}:{}", new Object[]{item, actPath, transition});
        if (actPath == null) {
            throw new WebAppExceptionBuilder().message("Must specify activity path").status(Response.Status.BAD_REQUEST).newCookie(cookie).build();
        }
        String outcome = null;
        try {
            String executeResult;
            AgentProxy agent = Gateway.getAgentProxy((AgentPath)this.getAgentPath(authCookie));
            FormDataBodyPart outcomeBodyPart = body.getField("outcome");
            String outcomeType = "application/json";
            if (outcomeBodyPart != null) {
                outcome = outcomeBodyPart.getValue();
                if (outcome.startsWith("<")) {
                    outcomeType = "application/xml";
                }
                log.debug("requestBinaryTransition() - outcome:'{}' contentType:'{}'", (Object)outcome, (Object)outcomeType);
            }
            FormDataBodyPart fileBodyPart = body.getField("file");
            InputStream file = null;
            String fileName = null;
            if (fileBodyPart != null) {
                file = (InputStream)fileBodyPart.getValueAs(InputStream.class);
                fileName = fileBodyPart.getContentDisposition().getFileName();
                log.debug("requestBinaryTransition() - attachment fileName:'{}'", (Object)fileName);
            }
            if (actPath.startsWith("workflow/predefined/")) {
                if (file != null) {
                    throw new WebAppExceptionBuilder().message("PredefinedStep '" + actPath + "' cannot have attahcment").status(Response.Status.BAD_REQUEST).newCookie(cookie).build();
                }
                executeResult = this.executePredefinedStep(item, outcome, outcomeType, actPath, agent);
            } else {
                transition = this.extractAndCheckTransitionName(transition, uri);
                executeResult = this.executeJob(item, outcome, outcomeType, file, fileName, actPath, transition, agent);
            }
            if (ItemRoot.produceJSON(headers.getAcceptableMediaTypes())) {
                return XML.toJSONObject((String)executeResult, (boolean)true).toString();
            }
            return executeResult;
        }
        catch (Exception e) {
            log.error("requestBinaryTransition() - could not execute {}://{}:{}'", new Object[]{item, actPath, transition, e});
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
        catch (Throwable t) {
            log.error("requestTransition() - could not execute {}://{}:{}'", new Object[]{item, actPath, transition, t});
            throw new WebAppExceptionBuilder().exception((Exception)new CriseVertxException(t)).newCookie(cookie).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="job/formModel/{activityPath: .*}")
    public Response getJobFormModel(@Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @PathParam(value="activityPath") String actPath, @QueryParam(value="transition") String transition, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        return this.getJobForm(uuid, actPath, transition, authCookie, uri, GeneratedFormType.NgDynamicFormModel);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="job/formLayout/{activityPath: .*}")
    public Response getJobFormLayout(@Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @PathParam(value="activityPath") String actPath, @QueryParam(value="transition") String transition, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        return this.getJobForm(uuid, actPath, transition, authCookie, uri, GeneratedFormType.NgDynamicFormLayout);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="job/formTemplate/{activityPath: .*}")
    public Response getJobFormTemplate(@Context HttpHeaders headers, @PathParam(value="uuid") String uuid, @PathParam(value="activityPath") String actPath, @QueryParam(value="transition") String transition, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        return this.getJobForm(uuid, actPath, transition, authCookie, uri, GeneratedFormType.NgDynamicFormTemplate);
    }

    private Response getJobForm(String uuid, String actPath, String transition, Cookie authCookie, UriInfo uri, GeneratedFormType formType) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        ItemProxy item = this.getProxy(uuid, cookie);
        if (actPath == null) {
            throw new WebAppExceptionBuilder().message("Must specify activity path").status(Response.Status.BAD_REQUEST).newCookie(cookie).build();
        }
        if (actPath.startsWith("workflow/predefined/")) {
            throw new WebAppExceptionBuilder().message("getJobFormTemplate() is unimplemented for PredefinedSteps").status(Response.Status.BAD_REQUEST).newCookie(cookie).build();
        }
        log.debug("getJobForm() - item:{} activityPath:{} formType:{}", new Object[]{item, actPath, formType});
        try {
            transition = this.extractAndCheckTransitionName(transition, uri);
            AgentProxy agent = Gateway.getAgentProxy((AgentPath)this.getAgentPath(authCookie));
            Job thisJob = item.getJobByTransitionName(actPath, transition, agent);
            if (thisJob == null) {
                throw new WebAppExceptionBuilder().message("Job not found for actPath:" + actPath + " transition:" + transition).status(Response.Status.NOT_FOUND).newCookie(cookie).build();
            }
            CastorHashMap inputs = (CastorHashMap)thisJob.getActProps().clone();
            inputs.put((Object)"agent", (Object)agent);
            inputs.put((Object)"item", (Object)item);
            inputs.put((Object)"job", (Object)thisJob);
            if (thisJob.hasOutcome()) {
                JSONArray formTemplate = new OutcomeBuilder(thisJob.getSchema(), false).generateNgDynamicFormsJson((Map)inputs, formType);
                return Response.ok((Object)formTemplate.toString()).cookie(new NewCookie[]{cookie}).build();
            }
            log.debug("getJobForm() - no outcome needed for job:{}", (Object)thisJob);
            return Response.noContent().cookie(new NewCookie[]{cookie}).build();
        }
        catch (Exception e) {
            throw new WebAppExceptionBuilder().exception(e).newCookie(cookie).build();
        }
    }

    private String extractAndCheckTransitionName(String transName, UriInfo uri) throws InvalidDataException {
        if (StringUtils.isNotBlank((CharSequence)transName)) {
            return transName;
        }
        for (String key : uri.getQueryParameters().keySet()) {
            List qparams = (List)uri.getQueryParameters().get((Object)key);
            if (qparams.size() != 1 || ((String)qparams.get(0)).length() != 0) continue;
            return key;
        }
        throw new InvalidDataException("Must specify transition name");
    }

    @GET
    @Path(value="roles")
    @Produces(value={"application/json"})
    public Response getRoles(@PathParam(value="uuid") String uuid, @CookieParam(value="cauth") Cookie authCookie, @Context UriInfo uri) {
        NewCookie cookie = this.checkAndCreateNewCookie(this.checkAuthCookie(authCookie));
        AgentProxy agent = this.getAgentProxy(uuid, cookie);
        RolePath[] roles = Gateway.getLookup().getRoles(agent.getPath());
        LinkedHashMap<String, URI> roleData = new LinkedHashMap<String, URI>();
        for (RolePath role : roles) {
            roleData.put(role.getName(), uri.getBaseUriBuilder().path("role").path(role.getName()).build(new Object[0]));
        }
        return this.toJSON(roleData, cookie).build();
    }
}

