/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.restapi;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.restapi.RestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="auth")
public class TokenLogin
extends RestHandler {
    private static final Logger log = LoggerFactory.getLogger(TokenLogin.class);

    @GET
    @Produces(value={"text/plain"})
    public Response login(@Context HttpHeaders headers, @QueryParam(value="user") String user, @QueryParam(value="pass") String pass) {
        try {
            AgentPath agentPath = Gateway.getSecurityManager().authenticate(user, pass, null).getPath();
            RestHandler.AuthData agentData = new RestHandler.AuthData((RestHandler)this, agentPath);
            try {
                String token = this.encryptAuthData(agentData);
                return Response.ok((Object)token).build();
            }
            catch (Exception e) {
                log.error("Error creating token", (Throwable)e);
                throw new WebApplicationException("Error creating token");
            }
        }
        catch (InvalidDataException e) {
            log.error("Problem logging in", (Throwable)e);
            throw new WebApplicationException("Problem logging in");
        }
        catch (ObjectNotFoundException e1) {
            throw new WebApplicationException("Bad username/password", 401);
        }
    }
}

