/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.trigger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.MemberSubscription;
import org.cristalise.kernel.entity.proxy.ProxyObserver;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.AbstractMain;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.StandardClient;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.trigger.QuartzJob;
import org.quartz.DateBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class TriggerProcess
extends StandardClient
implements ProxyObserver<Job> {
    private final ArrayList<String> transitions = new ArrayList();
    private Scheduler quartzScheduler = null;

    public TriggerProcess() throws InvalidDataException {
        Object[] transNames;
        StateMachine sm = TriggerProcess.getRequiredStateMachine((String)"Trigger", (String)"trigger", (String)"boot/SM/Trigger.xml");
        for (String string : transNames = Gateway.getProperties().getString("Trigger.StateMachine.transitions", "Warning,Timeout").split(",")) {
            sm.getValidTransitionID(string);
            this.transitions.add(string);
        }
        Logger.msg((int)5, (String)("TriggerProcess() - StateMachine:" + sm.getName() + " transitions:" + Arrays.toString(transNames)), (Object[])new Object[0]);
    }

    public void initialise() throws SchedulerException {
        StdSchedulerFactory schedFact = new StdSchedulerFactory();
        this.quartzScheduler = schedFact.getScheduler();
        this.quartzScheduler.start();
        Logger.msg((int)5, (String)"TriggerProcess.startScheduler() - Retrieving initial list of Jobs.", (Object[])new Object[0]);
        this.agent.subscribe(new MemberSubscription((ProxyObserver)this, ClusterType.JOB.getName(), true));
    }

    public void shutdownScheduler() throws SchedulerException {
        this.quartzScheduler.shutdown();
    }

    protected JobDetail buildJobDetail(Job currentJob, String jobID) {
        JobDataMap jdm = new JobDataMap();
        jdm.put("CristalAgent", (Object)this.agent);
        jdm.put("CristalJob", (Object)currentJob);
        return JobBuilder.newJob(QuartzJob.class).withIdentity(jobID).usingJobData(jdm).build();
    }

    protected void buildTriggersAndScehduleJob(Job currentJob, String jobID) {
        String transName = currentJob.getTransition().getName();
        Integer duration = (Integer)currentJob.getActProp(transName + "Duration");
        String unit = (String)currentJob.getActProp(transName + "Unit");
        Logger.msg((int)5, (String)("TriggerProcess.buildTriggersAndScehduleJob() - Scheduling job:" + jobID + " trans:" + transName + " Duration:" + duration + "[" + unit + "]"), (Object[])new Object[0]);
        try {
            SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(jobID).startAt(DateBuilder.futureDate((int)duration, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.valueOf((String)unit.toUpperCase()))).forJob(jobID).build();
            JobDetail jobDetail = this.buildJobDetail(currentJob, jobID);
            this.quartzScheduler.scheduleJob(jobDetail, (Trigger)trigger);
            Logger.msg((int)7, (String)("TriggerProcess.buildTriggersAndScehduleJob() - Scheduled job:" + jobID + " trans:" + transName + " Duration:" + duration + "[" + unit + "]"), (Object[])new Object[0]);
        }
        catch (Exception ex) {
            Logger.error((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Job currentJob) {
        String transName = currentJob.getTransition().getName();
        String jobID = Integer.toString(currentJob.getId());
        Boolean enabled = Gateway.getProperties().getBoolean("Trigger.enabled", true);
        Boolean transitionOn = (Boolean)currentJob.getActProp(transName + "On", (Object)true);
        Scheduler scheduler = this.quartzScheduler;
        synchronized (scheduler) {
            if (this.transitions.contains(transName)) {
                if (enabled.booleanValue() && transitionOn.booleanValue()) {
                    this.buildTriggersAndScehduleJob(currentJob, jobID);
                } else {
                    Logger.msg((int)7, (String)("TriggerProcess.add() - disabled trans:" + transName + " job:" + jobID), (Object[])new Object[0]);
                }
            } else {
                Logger.warning((String)("TriggerProcess.add() - UKNOWN trans:" + transName + " job:" + jobID), (Object[])new Object[0]);
            }
        }
    }

    public void control(String control, String msg) {
        if ("Error".equals(control)) {
            Logger.error((String)("Error in job subscription: " + msg), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String id) {
        Scheduler scheduler = this.quartzScheduler;
        synchronized (scheduler) {
            Logger.msg((int)7, (String)("TriggerProcess.remove() - id:" + id), (Object[])new Object[0]);
            try {
                this.quartzScheduler.deleteJob(new JobKey(id));
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        try {
            Gateway.init((Properties)TriggerProcess.readC2KArgs((String[])args));
            TriggerProcess proc = new TriggerProcess();
            proc.login(Gateway.getProperties().getString("Trigger.agent", "triggerAgent"), Gateway.getProperties().getString("Trigger.password"), Gateway.getProperties().getString("AuthResource", "Cristal"));
            proc.initialise();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    AbstractMain.shutdown((int)0);
                }
            });
        }
        catch (Exception ex) {
            Logger.error((Throwable)ex);
            try {
                Gateway.close();
            }
            catch (Exception ex1) {
                Logger.error((Throwable)ex1);
            }
            System.exit(1);
        }
    }

    public String getDesc() {
        return "Trigger Process";
    }

    public static void shutdown() {
    }
}

