/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.trigger;

import java.util.ArrayList;
import java.util.Properties;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.MemberSubscription;
import org.cristalise.kernel.entity.proxy.ProxyObserver;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.AbstractMain;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.StandardClient;
import org.cristalise.trigger.QuartzJob;
import org.quartz.DateBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerProcess
extends StandardClient
implements ProxyObserver<Job> {
    private static final Logger log = LoggerFactory.getLogger(TriggerProcess.class);
    private final ArrayList<String> transitions = new ArrayList();
    private Scheduler quartzScheduler = null;

    public TriggerProcess() throws InvalidDataException {
        String[] transNames;
        StateMachine sm = TriggerProcess.getRequiredStateMachine((String)"Trigger", (String)"trigger", (String)"boot/SM/Trigger.xml");
        for (String transName : transNames = Gateway.getProperties().getString("Trigger.StateMachine.transitions", "Warning,Timeout").split(",")) {
            sm.getValidTransitionID(transName);
            this.transitions.add(transName);
        }
        log.debug("StateMachine:{} transitions:{}", (Object)sm.getName(), (Object)transNames);
    }

    public void initialise() throws SchedulerException {
        StdSchedulerFactory schedFact = new StdSchedulerFactory();
        this.quartzScheduler = schedFact.getScheduler();
        this.quartzScheduler.start();
        log.debug("startScheduler() - Retrieving initial list of Jobs.");
        this.agent.subscribe(new MemberSubscription((ProxyObserver)this, ClusterType.JOB.getName(), true));
    }

    public void shutdownScheduler() throws SchedulerException {
        this.quartzScheduler.shutdown();
    }

    protected JobDetail buildJobDetail(Job currentJob, String jobID) {
        JobDataMap jdm = new JobDataMap();
        jdm.put("CristalAgent", (Object)this.agent);
        jdm.put("CristalJob", (Object)currentJob);
        return JobBuilder.newJob(QuartzJob.class).withIdentity(jobID).usingJobData(jdm).build();
    }

    protected void buildTriggersAndScehduleJob(Job currentJob, String jobID) {
        String transName = currentJob.getTransition().getName();
        Integer duration = (Integer)currentJob.getActProp(transName + "Duration");
        String unit = (String)currentJob.getActProp(transName + "Unit");
        log.debug("buildTriggersAndScehduleJob() - Scheduling job:" + jobID + " trans:" + transName + " Duration:" + duration + "[" + unit + "]");
        try {
            SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(jobID).startAt(DateBuilder.futureDate((int)duration, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.valueOf((String)unit.toUpperCase()))).forJob(jobID).build();
            JobDetail jobDetail = this.buildJobDetail(currentJob, jobID);
            this.quartzScheduler.scheduleJob(jobDetail, (Trigger)trigger);
            log.debug("buildTriggersAndScehduleJob() - Scheduled job:" + jobID + " trans:" + transName + " Duration:" + duration + "[" + unit + "]");
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Job currentJob) {
        String transName = currentJob.getTransition().getName();
        String jobID = Integer.toString(currentJob.getId());
        Boolean enabled = Gateway.getProperties().getBoolean("Trigger.enabled", true);
        Boolean transitionOn = (Boolean)currentJob.getActProp(transName + "On", (Object)true);
        Scheduler scheduler = this.quartzScheduler;
        synchronized (scheduler) {
            if (this.transitions.contains(transName)) {
                if (enabled.booleanValue() && transitionOn.booleanValue()) {
                    this.buildTriggersAndScehduleJob(currentJob, jobID);
                } else {
                    log.debug("add() - disabled trans:" + transName + " job:" + jobID);
                }
            } else {
                log.warn("add() - UKNOWN trans:" + transName + " job:" + jobID);
            }
        }
    }

    public void control(String control, String msg) {
        if ("Error".equals(control)) {
            log.error("Error in job subscription: " + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String id) {
        Scheduler scheduler = this.quartzScheduler;
        synchronized (scheduler) {
            log.debug("remove() - id:" + id);
            try {
                this.quartzScheduler.deleteJob(new JobKey(id));
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        try {
            Gateway.init((Properties)TriggerProcess.readC2KArgs((String[])args));
            TriggerProcess proc = new TriggerProcess();
            proc.login(Gateway.getProperties().getString("Trigger.agent", "triggerAgent"), Gateway.getProperties().getString("Trigger.password"), Gateway.getProperties().getString("AuthResource", "Cristal"));
            proc.initialise();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    AbstractMain.shutdown((int)0);
                }
            });
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            try {
                Gateway.close();
            }
            catch (Exception ex1) {
                log.error("", (Throwable)ex1);
            }
            System.exit(1);
        }
    }

    public String getDesc() {
        return "Trigger Process";
    }

    public static void shutdown() {
    }
}

