/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage.xmldb;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.utils.Logger;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class XMLDBClusterStorage
extends ClusterStorage {
    public static final String XMLDB_URI = "XMLDB.URI";
    public static final String XMLDB_USER = "XMLDB.user";
    public static final String XMLDB_PASSWORD = "XMLDB.password";
    public static final String XMLDB_ROOT = "XMLDB.root";
    protected Database database;
    protected Collection root;

    protected static Collection verifyCollection(Collection parent, String name, boolean create) throws PersistencyException {
        Collection coll;
        try {
            coll = parent.getChildCollection(name);
            if (coll == null) {
                throw new XMLDBException(200);
            }
        }
        catch (XMLDBException ex) {
            if (ex.errorCode == 200) {
                if (create) {
                    try {
                        CollectionManagementService collManager = (CollectionManagementService)parent.getService("CollectionManagementService", "1.0");
                        coll = collManager.createCollection(name);
                    }
                    catch (Exception ex2) {
                        throw new PersistencyException("Could not create XMLDB collection for item " + name);
                    }
                }
                return null;
            }
            Logger.error((Throwable)ex);
            throw new PersistencyException("Error loading XMLDB collection for item " + name);
        }
        return coll;
    }

    public void open(Authenticator auth) throws PersistencyException {
        String driver = "org.exist.xmldb.DatabaseImpl";
        try {
            Class<?> cl = Class.forName("org.exist.xmldb.DatabaseImpl");
            this.database = (Database)cl.newInstance();
            this.database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)this.database);
            Collection db = DatabaseManager.getCollection((String)Gateway.getProperties().getString(XMLDB_URI), (String)Gateway.getProperties().getString(XMLDB_USER), (String)Gateway.getProperties().getString(XMLDB_PASSWORD));
            String rootColl = Gateway.getProperties().getString(XMLDB_ROOT);
            if (rootColl != null && rootColl.length() > 0) {
                this.root = XMLDBClusterStorage.verifyCollection(db, rootColl, true);
                db.close();
            } else {
                this.root = db;
            }
        }
        catch (Exception ex) {
            Logger.error((Throwable)ex);
            throw new PersistencyException("Error initializing XMLDB");
        }
        if (this.root == null) {
            throw new PersistencyException("Root collection is null. Problem connecting to XMLDB.");
        }
    }

    public void close() throws PersistencyException {
        try {
            this.root.close();
        }
        catch (XMLDBException e) {
            Logger.error((Throwable)e);
            throw new PersistencyException("Error shutting down eXist XMLDB");
        }
    }

    public short queryClusterSupport(String clusterType) {
        return 3;
    }

    public String getName() {
        return "XMLDB";
    }

    public String getId() {
        return "XMLDB";
    }

    public C2KLocalObject get(ItemPath itemPath, String path) throws PersistencyException {
        String type = ClusterStorage.getClusterType((String)path);
        String subPath = itemPath.getUUID().toString();
        Collection itemColl = XMLDBClusterStorage.verifyCollection(this.root, subPath, false);
        if (itemColl == null) {
            return null;
        }
        try {
            String resourceName = path.replace('/', '.');
            Resource resource = itemColl.getResource(resourceName);
            if (resource != null) {
                String objString = (String)resource.getContent();
                itemColl.close();
                if (type.equals("Outcome")) {
                    return new Outcome(path, objString);
                }
                C2KLocalObject obj = (C2KLocalObject)Gateway.getMarshaller().unmarshall(objString);
                return obj;
            }
            return null;
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw new PersistencyException("XMLDB error");
        }
    }

    public void put(ItemPath itemPath, C2KLocalObject obj) throws PersistencyException {
        String resName = XMLDBClusterStorage.getPath((C2KLocalObject)obj);
        String subPath = itemPath.getUUID().toString();
        Collection itemColl = XMLDBClusterStorage.verifyCollection(this.root, subPath, true);
        try {
            resName = resName.replace('/', '.');
            String objString = Gateway.getMarshaller().marshall((Object)obj);
            Resource res = itemColl.getResource(resName);
            if (res == null) {
                res = itemColl.createResource(resName, "XMLResource");
            }
            res.setContent((Object)objString);
            itemColl.storeResource(res);
            itemColl.close();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw new PersistencyException("XMLDB error");
        }
    }

    public void delete(ItemPath itemPath, String path) throws PersistencyException {
        String subPath = itemPath.getUUID().toString();
        Collection itemColl = XMLDBClusterStorage.verifyCollection(this.root, subPath, false);
        if (itemColl == null) {
            return;
        }
        try {
            String resource = path.replace('/', '.');
            Resource res = itemColl.getResource(resource);
            if (res != null) {
                itemColl.removeResource(res);
            }
            itemColl.close();
            itemColl.close();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            throw new PersistencyException("XMLClusterStorage.delete() - Could not delete " + path + " to " + itemPath);
        }
    }

    public String[] getClusterContents(ItemPath itemPath, String path) throws PersistencyException {
        String subPath = itemPath.getUUID().toString();
        Collection coll = XMLDBClusterStorage.verifyCollection(this.root, subPath, false);
        if (coll == null) {
            return new String[0];
        }
        ArrayList<String> contents = new ArrayList<String>();
        StringBuffer resPrefix = new StringBuffer();
        String[] pathComps = path.split("/");
        if (pathComps.length > 0) {
            for (int i = 0; i < pathComps.length; ++i) {
                if (pathComps[i].length() <= 0) continue;
                resPrefix.append(pathComps[i]).append(".");
            }
        }
        try {
            for (String res : coll.listResources()) {
                if (!res.startsWith(resPrefix.toString())) continue;
                String resName = URLDecoder.decode(res.substring(resPrefix.length()), "UTF-8");
                if (resName.indexOf(46) > -1) {
                    resName = resName.substring(0, resName.indexOf(46));
                }
                if (contents.contains(resName)) continue;
                contents.add(resName);
            }
        }
        catch (XMLDBException e) {
            Logger.error((Throwable)e);
            throw new PersistencyException("Error listing collection resources for item " + itemPath);
        }
        catch (UnsupportedEncodingException e) {
            Logger.error((Throwable)e);
            throw new PersistencyException("Error listing decoding resource name for item " + itemPath);
        }
        return contents.toArray(new String[contents.size()]);
    }
}

