/*
 * Copyright 2011 cruxframework.org.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.cruxframework.crux.core.rebind.screen.widget.creator.align;

import org.cruxframework.crux.core.rebind.AbstractProxyCreator.SourcePrinter;
import org.cruxframework.crux.core.rebind.screen.widget.AttributeProcessor;
import org.cruxframework.crux.core.rebind.screen.widget.WidgetCreator;
import org.cruxframework.crux.core.rebind.screen.widget.WidgetCreatorContext;

import com.google.gwt.user.client.ui.HasAutoHorizontalAlignment;

/**
 * 
 * @author Thiago da Rosa de Bustamante
 *
 */
public class AutoHorizontalAlignmentAttributeParser<C extends WidgetCreatorContext> extends AttributeProcessor<C>
{
	public AutoHorizontalAlignmentAttributeParser(WidgetCreator<?> widgetCreator)
    {
	    super(widgetCreator);
    }

	@Override
    public void processAttribute(SourcePrinter out, C context, String attributeValue)
    {
		out.println(context.getWidget()+".setAutoHorizontalAlignment("+
				AlignmentAttributeParser.getAutoHorizontalAlignment(attributeValue, HasAutoHorizontalAlignment.class.getCanonicalName()+".ALIGN_DEFAULT")+");");
    }
}
