/*
 * Copyright 2011 cruxframework.org.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.cruxframework.crux.widgets.rebind.swappanel;

import org.cruxframework.crux.core.rebind.screen.widget.WidgetCreator;
import org.cruxframework.crux.core.rebind.screen.widget.WidgetCreatorContext;
import org.cruxframework.crux.core.rebind.screen.widget.creator.children.AnyWidgetChildProcessor;
import org.cruxframework.crux.core.rebind.screen.widget.declarative.DeclarativeFactory;
import org.cruxframework.crux.core.rebind.screen.widget.declarative.TagAttribute;
import org.cruxframework.crux.core.rebind.screen.widget.declarative.TagAttributes;
import org.cruxframework.crux.core.rebind.screen.widget.declarative.TagChild;
import org.cruxframework.crux.core.rebind.screen.widget.declarative.TagChildren;
import org.cruxframework.crux.core.rebind.screen.widget.declarative.TagConstraints;
import org.cruxframework.crux.core.rebind.screen.widget.declarative.TagEvent;
import org.cruxframework.crux.core.rebind.screen.widget.declarative.TagEvents;
import org.cruxframework.crux.widgets.client.swappanel.HorizontalSwapPanel;
import org.cruxframework.crux.widgets.rebind.event.SwapEvtBind;

/**
 * 
 * @author Thiago Bustamante
 *
 */
@DeclarativeFactory(id="horizontalSwapPanel", library="widgets", targetWidget=HorizontalSwapPanel.class, 
	description="A simple panel that changes its content using an horizontal swap animation.")
@TagChildren({
	@TagChild(HorizontalSwapPanelFactory.WidgetContentProcessor.class)
})
@TagAttributes({
	@TagAttribute(value="transitionDuration", type=Integer.class, required=false, defaultValue="500"),
	@TagAttribute(value="useFadeTransitions", type=Boolean.class, required=false, defaultValue="false")
})
@TagEvents({
	@TagEvent(SwapEvtBind.class)
})
public class HorizontalSwapPanelFactory extends WidgetCreator<WidgetCreatorContext>
{
    @TagConstraints(minOccurs="0", maxOccurs="1", widgetProperty="currentWidget")
    public static class WidgetContentProcessor extends AnyWidgetChildProcessor<WidgetCreatorContext> {}
    
	@Override
    public WidgetCreatorContext instantiateContext()
    {
	    return new WidgetCreatorContext();
    }
}
