/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.accumulator;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cryptimeleon.craco.accumulator.AccumulatorDigest;
import org.cryptimeleon.craco.accumulator.AccumulatorWitness;
import org.cryptimeleon.craco.accumulator.nguyen.NguyenAccumulatorScheme;
import org.cryptimeleon.craco.accumulator.nguyen.NguyenDigest;
import org.cryptimeleon.craco.accumulator.nguyen.NguyenWitness;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.structures.groups.debug.DebugBilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NguyenAccumulatorTest {
    private NguyenAccumulatorScheme scheme;
    private Zn.ZnElement singleValue;
    private Set<Zn.ZnElement> singleIdentitySet;
    private Set<Zn.ZnElement> multipleIdentities;
    private Set<Zn.ZnElement> tooLargeSet;
    private Zn zn;

    @Before
    public void setup() {
        int numberIdentities = 100;
        DebugBilinearGroup group = new DebugBilinearGroup(128, BilinearGroup.Type.TYPE_3);
        this.scheme = NguyenAccumulatorScheme.setup((BilinearGroup)group, (int)numberIdentities);
        this.zn = group.getZn();
        this.singleValue = this.zn.getUniformlyRandomElement();
        this.singleIdentitySet = new HashSet<Zn.ZnElement>(Arrays.asList(this.singleValue));
        this.multipleIdentities = new LinkedHashSet<Zn.ZnElement>(this.singleIdentitySet);
        Stream.generate(() -> this.zn.getUniformlyRandomElement()).limit(numberIdentities - 3).collect(Collectors.toCollection(() -> this.multipleIdentities));
        this.tooLargeSet = new LinkedHashSet<Zn.ZnElement>(this.singleIdentitySet);
        Stream.generate(() -> this.zn.getUniformlyRandomElement()).limit(numberIdentities).collect(Collectors.toCollection(() -> this.tooLargeSet));
    }

    @Test
    public void testCreate() {
        NguyenDigest value = this.scheme.createDigest(this.singleIdentitySet);
        NguyenDigest valueMultiple = this.scheme.createDigest(this.multipleIdentities);
        Assert.assertNotNull((Object)value);
        Assert.assertNotNull((Object)valueMultiple);
    }

    @Test
    public void testVerify() {
        NguyenDigest digest = this.scheme.createDigest(this.multipleIdentities);
        NguyenWitness witness = this.scheme.createWitness((AccumulatorDigest)digest, this.multipleIdentities, this.singleValue);
        Assert.assertNotNull((Object)witness);
        Assert.assertTrue((boolean)this.scheme.verify((AccumulatorDigest)digest, this.singleValue, (AccumulatorWitness)witness));
    }

    @Test
    public void testInsert() {
        Zn.ZnElement additionalValue;
        Set<Zn.ZnElement> oldSet = this.multipleIdentities;
        NguyenDigest oldAcc = this.scheme.createDigest(oldSet);
        while (oldSet.contains(additionalValue = this.zn.getUniformlyRandomElement())) {
        }
        NguyenDigest newAcc = (NguyenDigest)this.scheme.insert((AccumulatorDigest)oldAcc, oldSet, (Representable)additionalValue);
        HashSet<Zn.ZnElement> newSet = new HashSet<Zn.ZnElement>(oldSet);
        newSet.add(additionalValue);
        NguyenWitness oldWitness = this.scheme.createWitness((AccumulatorDigest)oldAcc, oldSet, this.singleValue);
        NguyenWitness newWitness = this.scheme.updateWitness((AccumulatorDigest)oldAcc, (AccumulatorDigest)newAcc, oldSet, newSet, this.singleValue, (AccumulatorWitness)oldWitness);
        Assert.assertNotNull((Object)newWitness);
        Assert.assertTrue((boolean)this.scheme.verify((AccumulatorDigest)newAcc, this.singleValue, (AccumulatorWitness)newWitness));
    }

    @Test
    public void testDelete() {
        Set<Zn.ZnElement> oldSet = this.multipleIdentities;
        NguyenDigest oldAcc = this.scheme.createDigest(oldSet);
        Zn.ZnElement valueToRemove = null;
        for (Zn.ZnElement val : oldSet) {
            if (val.equals((Object)this.singleValue)) continue;
            valueToRemove = val;
            break;
        }
        NguyenDigest newAcc = (NguyenDigest)this.scheme.delete((AccumulatorDigest)oldAcc, oldSet, valueToRemove);
        HashSet<Zn.ZnElement> newSet = new HashSet<Zn.ZnElement>(oldSet);
        newSet.remove(valueToRemove);
        NguyenWitness oldWitness = this.scheme.createWitness((AccumulatorDigest)oldAcc, oldSet, this.singleValue);
        NguyenWitness newWitness = this.scheme.updateWitness((AccumulatorDigest)oldAcc, (AccumulatorDigest)newAcc, oldSet, newSet, this.singleValue, (AccumulatorWitness)oldWitness);
        Assert.assertNotNull((Object)newWitness);
        Assert.assertTrue((boolean)this.scheme.verify((AccumulatorDigest)newAcc, this.singleValue, (AccumulatorWitness)newWitness));
    }
}

