/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.enc.representation;

import java.math.BigInteger;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.enc.CipherText;
import org.cryptimeleon.craco.enc.DecryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKeyPair;
import org.cryptimeleon.craco.enc.EncryptionScheme;
import org.cryptimeleon.craco.enc.asym.elgamal.ElgamalEncryption;
import org.cryptimeleon.craco.enc.representation.RepresentationTestParams;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.RingGroup;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class ElgamalParams {
    public static RepresentationTestParams getParams() {
        Zp zp = new Zp(BigInteger.valueOf(71L));
        RingGroup zpGroup = zp.asUnitGroup();
        ElgamalEncryption elgamalScheme = new ElgamalEncryption((Group)zpGroup);
        EncryptionKeyPair validKeyPair = elgamalScheme.generateKeyPair();
        EncryptionKey validPK = validKeyPair.getPk();
        DecryptionKey validSK = validKeyPair.getSk();
        GroupElementPlainText plaintext = new GroupElementPlainText(zpGroup.getUniformlyRandomElement());
        CipherText ciphertext = elgamalScheme.encrypt((PlainText)plaintext, validPK);
        return new RepresentationTestParams((EncryptionScheme)elgamalScheme, validPK, validSK, (PlainText)plaintext, ciphertext);
    }
}

