/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.ser.standalone.params;

import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.bbs.BBSBKeyGen;
import org.cryptimeleon.craco.sig.bbs.BBSBPublicParameter;
import org.cryptimeleon.craco.sig.bbs.BBSBSignatureScheme;
import org.cryptimeleon.craco.sig.hashthensign.HashThenSign;
import org.cryptimeleon.craco.sig.ps.PSExtendedSignatureScheme;
import org.cryptimeleon.craco.sig.ps.PSPublicParameters;
import org.cryptimeleon.craco.sig.ps.PSPublicParametersGen;
import org.cryptimeleon.craco.sig.ps.PSSignatureScheme;
import org.cryptimeleon.craco.sig.ps18.PS18ROMSignatureScheme;
import org.cryptimeleon.craco.sig.ps18.PS18SignatureScheme;
import org.cryptimeleon.craco.sig.sps.eq.SPSEQPublicParameters;
import org.cryptimeleon.craco.sig.sps.eq.SPSEQPublicParametersGen;
import org.cryptimeleon.craco.sig.sps.eq.SPSEQSignatureScheme;
import org.cryptimeleon.math.hash.HashFunction;
import org.cryptimeleon.math.hash.impl.VariableOutputLengthHashFunction;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.standalone.StandaloneReprSubTest;

public class SignatureStandaloneReprTests
extends StandaloneReprSubTest {
    private final PSPublicParameters pp = new PSPublicParametersGen().generatePublicParameter(128, true);

    public void testSPSEQ() {
        SPSEQPublicParameters pp = new SPSEQPublicParametersGen().generatePublicParameter(128, true);
        SPSEQSignatureScheme signatureScheme = new SPSEQSignatureScheme(pp);
        this.test((StandaloneRepresentable)signatureScheme);
        this.test((StandaloneRepresentable)pp);
    }

    public void testPS() {
        this.test((StandaloneRepresentable)this.pp);
        this.test((StandaloneRepresentable)new PSSignatureScheme(this.pp));
        this.test((StandaloneRepresentable)new PSExtendedSignatureScheme(this.pp));
        this.test((StandaloneRepresentable)new PS18ROMSignatureScheme(this.pp));
        this.test((StandaloneRepresentable)new PS18SignatureScheme(this.pp));
        this.test((StandaloneRepresentable)new HashThenSign((HashFunction)new VariableOutputLengthHashFunction((this.pp.getZp().size().bitLength() - 1) / 8), (SignatureScheme)new PSSignatureScheme(this.pp)));
    }

    public void testBBS() {
        BBSBKeyGen setup = new BBSBKeyGen();
        BBSBPublicParameter pp = setup.doKeyGen(80, true);
        this.test((StandaloneRepresentable)pp);
        this.test((StandaloneRepresentable)new BBSBSignatureScheme(pp));
    }
}

