/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.bbs;

import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SignatureSchemeParams;
import org.cryptimeleon.craco.sig.SignatureSchemeTester;
import org.cryptimeleon.craco.sig.bbs.BBSBPublicParameter;
import org.cryptimeleon.craco.sig.bbs.BBSBSignatureScheme;
import org.cryptimeleon.craco.sig.bbs.BBSBSigningKey;
import org.cryptimeleon.craco.sig.bbs.BBSBVerificationKey;
import org.cryptimeleon.craco.sig.bbs.BBSSignatureSchemeTestParamGenerator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BBSBSignatureSchemeTest {
    private BBSBSignatureScheme bbsScheme;
    private BBSBPublicParameter pp;
    private SignatureKeyPair<BBSBVerificationKey, BBSBSigningKey> keys;
    private SignatureKeyPair<BBSBVerificationKey, BBSBSigningKey> wrongKeys;
    private MessageBlock messageBlock;
    private MessageBlock wrongMessageBlock;

    @Before
    public void setUp() throws Exception {
        SignatureSchemeParams params = BBSSignatureSchemeTestParamGenerator.generateParams(80);
        this.bbsScheme = (BBSBSignatureScheme)params.getSignatureScheme();
        this.pp = (BBSBPublicParameter)params.getPublicParameters();
        this.keys = params.getKeyPair1();
        this.wrongKeys = params.getKeyPair2();
        this.messageBlock = (MessageBlock)params.getMessage1();
        this.wrongMessageBlock = (MessageBlock)params.getMessage2();
    }

    @Test
    public void testBBSSignatureSchemeRepresentationText() {
        SignatureSchemeTester.testRepresentationSignatureScheme((SignatureScheme)this.bbsScheme, (PlainText)this.messageBlock, this.keys.getVerificationKey(), this.keys.getSigningKey());
        BBSBPublicParameter ppTest = new BBSBPublicParameter(this.pp.getRepresentation());
        Assert.assertEquals((Object)this.pp, (Object)ppTest);
    }

    @Test
    public void testBBSSignatureSchemeSignAndVerify() {
        SignatureSchemeTester.testSignatureSchemeSignAndVerify((SignatureScheme)this.bbsScheme, (PlainText)this.messageBlock, this.keys.getVerificationKey(), this.keys.getSigningKey());
    }

    @Test
    public void testNegativeWrongMessagePSSignatureSchemeSignAndVerify() {
        SignatureSchemeTester.testNegativeWrongMessageSignatureSchemeSignAndVerify((SignatureScheme)this.bbsScheme, (PlainText)this.messageBlock, (PlainText)this.wrongMessageBlock, this.keys.getVerificationKey(), this.keys.getSigningKey());
    }

    @Test
    public void testNegativeWrongKeyPSSignatureSchemeSignAndVerify() {
        SignatureSchemeTester.testNegativeWrongKeysSignatureSchemeSignAndVerify((SignatureScheme)this.bbsScheme, (PlainText)this.messageBlock, this.keys.getVerificationKey(), this.keys.getSigningKey(), this.wrongKeys.getVerificationKey(), this.wrongKeys.getSigningKey());
    }

    @Test
    public void testMapToPlaintext() {
        SignatureSchemeTester.testMapToPlaintext((SignatureScheme)this.bbsScheme, this.keys.getVerificationKey());
    }

    @Test
    public void testMapToPlaintextContract() {
        SignatureSchemeTester.testMapToPlainTextContract((SignatureScheme)this.bbsScheme, this.keys);
    }
}

