/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.ps;

import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.common.plaintexts.RingElementPlainText;
import org.cryptimeleon.craco.protocols.TwoPartyProtocolInstance;
import org.cryptimeleon.craco.protocols.arguments.damgardtechnique.DamgardTechnique;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.ps.PSBlindSignProtocol;
import org.cryptimeleon.craco.sig.ps.PSExtendedSignatureScheme;
import org.cryptimeleon.craco.sig.ps.PSExtendedVerificationKey;
import org.cryptimeleon.craco.sig.ps.PSPublicParameters;
import org.cryptimeleon.craco.sig.ps.PSSignature;
import org.cryptimeleon.craco.sig.ps.PSSigningKey;
import org.cryptimeleon.math.structures.cartesian.Vector;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.debug.DebugBilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BlindIssueProtocolTest {
    @Test
    public void testBlindSign() {
        DebugBilinearGroup group = new DebugBilinearGroup(128, BilinearGroup.Type.TYPE_3);
        Zn zn = group.getZn();
        PSExtendedSignatureScheme scheme = new PSExtendedSignatureScheme(new PSPublicParameters((BilinearGroup)group));
        SignatureKeyPair keyPair = scheme.generateKeyPair(6);
        MessageBlock message = (MessageBlock)new Vector((Object[])new Integer[]{4, 8, 15, 16, 23, 42}).map(i -> new RingElementPlainText((RingElement)zn.valueOf((long)i.intValue())), MessageBlock::new);
        PSBlindSignProtocol protocol = new PSBlindSignProtocol(scheme, DamgardTechnique.generateCommitmentScheme((Group)group.getG1()));
        PSBlindSignProtocol.BlindSignProtocolInstance receiver = protocol.instantiateProtocolForReceiver((PSExtendedVerificationKey)keyPair.getVerificationKey(), new PSBlindSignProtocol.ReceiverInput(message));
        PSBlindSignProtocol.BlindSignProtocolInstance signer = protocol.instantiateProtocolForSigner((PSExtendedVerificationKey)keyPair.getVerificationKey(), (PSSigningKey)keyPair.getSigningKey());
        protocol.runProtocolLocally((TwoPartyProtocolInstance)receiver, (TwoPartyProtocolInstance)signer);
        PSSignature signature = receiver.getResultSignature();
        Assertions.assertTrue((boolean)scheme.verify((PlainText)message, (Signature)signature, keyPair.getVerificationKey()));
    }
}

