/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.eq;

import org.cryptimeleon.craco.common.PublicParameters;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SignatureScheme;
import org.cryptimeleon.craco.sig.SignatureSchemeParams;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.sps.eq.SPSEQPublicParameters;
import org.cryptimeleon.craco.sig.sps.eq.SPSEQPublicParametersGen;
import org.cryptimeleon.craco.sig.sps.eq.SPSEQSignatureScheme;
import org.cryptimeleon.craco.sig.sps.eq.SPSEQSigningKey;
import org.cryptimeleon.craco.sig.sps.eq.SPSEQVerificationKey;

public class SPSEQSignatureSchemeTestParamGenerator {
    public static SignatureSchemeParams generateParams(int securityParam, int numMessages) {
        SignatureKeyPair wrongKeyPair;
        SPSEQPublicParametersGen ppSetup = new SPSEQPublicParametersGen();
        SPSEQPublicParameters pp = ppSetup.generatePublicParameter(securityParam, true);
        SPSEQSignatureScheme spseqScheme = new SPSEQSignatureScheme(pp);
        SignatureKeyPair keyPair = spseqScheme.generateKeyPair(numMessages);
        while (((SPSEQVerificationKey)(wrongKeyPair = spseqScheme.generateKeyPair(numMessages)).getVerificationKey()).equals((Object)keyPair.getVerificationKey()) || ((SPSEQSigningKey)wrongKeyPair.getSigningKey()).equals((Object)keyPair.getSigningKey())) {
        }
        GroupElementPlainText[] messages = new GroupElementPlainText[numMessages];
        for (int i = 0; i < messages.length; ++i) {
            messages[i] = new GroupElementPlainText(pp.getBilinearMap().getG1().getUniformlyRandomElement());
        }
        MessageBlock messageBlock = new MessageBlock((PlainText[])messages);
        GroupElementPlainText[] wrongMessages = new GroupElementPlainText[numMessages];
        for (int i = 0; i < wrongMessages.length; ++i) {
            do {
                wrongMessages[i] = new GroupElementPlainText(pp.getBilinearMap().getG1().getUniformlyRandomElement());
            } while (wrongMessages[i].equals((Object)messages[i]));
        }
        MessageBlock wrongMessageBlock = new MessageBlock((PlainText[])wrongMessages);
        return new SignatureSchemeParams((SignatureScheme)spseqScheme, (PublicParameters)pp, (PlainText)messageBlock, (PlainText)wrongMessageBlock, (SignatureKeyPair<? extends VerificationKey, ? extends SigningKey>)keyPair, (SignatureKeyPair<? extends VerificationKey, ? extends SigningKey>)wrongKeyPair);
    }
}

