/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.commitment;

import org.cryptimeleon.craco.commitment.Commitment;
import org.cryptimeleon.craco.commitment.OpenValue;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.Representation;

public class CommitmentPair
implements Representable,
UniqueByteRepresentable {
    private final Commitment commitment;
    private final OpenValue openValue;

    public CommitmentPair(Commitment commitment, OpenValue openValue) {
        this.commitment = commitment;
        this.openValue = openValue;
    }

    public Commitment getCommitment() {
        return this.commitment;
    }

    public OpenValue getOpenValue() {
        return this.openValue;
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        accumulator.escapeAndSeparate((UniqueByteRepresentable)this.commitment);
        accumulator.escapeAndSeparate((UniqueByteRepresentable)this.openValue);
        return accumulator;
    }

    public Representation getRepresentation() {
        ObjectRepresentation repr = new ObjectRepresentation();
        repr.put("com", this.commitment.getRepresentation());
        repr.put("open", this.openValue.getRepresentation());
        return repr;
    }
}

