/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.commitment.pedersen;

import java.util.Objects;
import org.cryptimeleon.craco.commitment.Commitment;
import org.cryptimeleon.craco.commitment.CommitmentPair;
import org.cryptimeleon.craco.commitment.CommitmentScheme;
import org.cryptimeleon.craco.commitment.OpenValue;
import org.cryptimeleon.craco.commitment.pedersen.PedersenCommitment;
import org.cryptimeleon.craco.commitment.pedersen.PedersenOpenValue;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.common.plaintexts.RingElementPlainText;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.cartesian.Vector;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.cartesian.GroupElementVector;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.cartesian.RingElementVector;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class PedersenCommitmentScheme
implements CommitmentScheme {
    @Represented
    protected Group group;
    @Represented(restorer="group")
    protected GroupElementVector h;
    @Represented(restorer="group")
    protected GroupElement g;

    public PedersenCommitmentScheme(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    public PedersenCommitmentScheme(Group group, GroupElement g, GroupElementVector h) {
        this.group = group;
        this.h = h;
        this.g = g;
    }

    public PedersenCommitmentScheme(Group group, int numMessages) {
        this.group = group;
        this.h = group.getUniformlyRandomElements(numMessages);
        this.g = group.getUniformlyRandomNonNeutral();
    }

    @Override
    public CommitmentPair commit(PlainText plainText) {
        return this.commit(this.plaintextToRingElementVector(plainText));
    }

    public CommitmentPair commit(Zn.ZnElement ... valuesToCommit) {
        return this.commit(new RingElementVector((RingElement[])valuesToCommit));
    }

    public CommitmentPair commit(RingElementVector valuesToCommit) {
        return this.commit(valuesToCommit, this.group.getUniformlyRandomExponent());
    }

    public CommitmentPair commit(RingElementVector valuesToCommit, Zn.ZnElement randomness) {
        if (valuesToCommit.length() != this.h.length()) {
            throw new UnsupportedOperationException("Plaintext must consist of " + this.h.length() + " ZnElements");
        }
        GroupElement c = this.h.innerProduct((Vector)valuesToCommit).op((Element)this.g.pow(randomness));
        return new CommitmentPair(new PedersenCommitment(c), new PedersenOpenValue(randomness));
    }

    @Override
    public boolean verify(Commitment commitment, OpenValue openValue, PlainText plainText) {
        return this.verify(commitment, openValue, this.plaintextToRingElementVector(plainText));
    }

    public boolean verify(Commitment commitment, OpenValue openValue, RingElementVector committedValues) {
        return this.commit(committedValues, ((PedersenOpenValue)openValue).getRandomValue()).getCommitment().equals(commitment);
    }

    @Override
    public MessageBlock mapToPlainText(byte[] bytes) throws IllegalArgumentException {
        RingElementPlainText zero = new RingElementPlainText((RingElement)this.group.getZn().getZeroElement());
        return new MessageBlock((Vector<? extends PlainText>)Vector.of((Object[])new RingElementPlainText[]{new RingElementPlainText((RingElement)this.group.getZn().injectiveValueOf(bytes))}).pad((Object)zero, this.h.length()));
    }

    @Override
    public PedersenCommitment restoreCommitment(Representation repr) {
        return new PedersenCommitment(this.group.restoreElement(repr));
    }

    @Override
    public PedersenOpenValue restoreOpenValue(Representation repr) {
        return new PedersenOpenValue(this.group.getZn().restoreElement(repr));
    }

    private RingElementVector plaintextToRingElementVector(PlainText plainText) {
        if (plainText instanceof RingElementPlainText) {
            plainText = new MessageBlock(plainText);
        }
        if (!(plainText instanceof MessageBlock)) {
            throw new IllegalArgumentException("Not a valid PlainText for this scheme");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        return new RingElementVector(messageBlock.map(m -> ((RingElementPlainText)m).getRingElement()));
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PedersenCommitmentScheme that = (PedersenCommitmentScheme)o;
        return Objects.equals(this.group, that.group) && Objects.equals(this.h, that.h) && Objects.equals(this.g, that.g);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.h, this.g);
    }
}

